#-
# Copyright (c) 2000 Doug Rabson
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: src/sys/alpha/pci/alphapci_if.m,v 1.2 2005/01/05 20:05:51 imp Exp $
#

#include <sys/bus.h>
#include <alpha/pci/pcibus.h>

INTERFACE alphapci;

CODE {
	static void *null_cvt(device_t dev, vm_offset_t ba)
	{
		return 0;
	}
};

METHOD void * cvt_dense {
	device_t	dev;
	vm_offset_t	ba;
} DEFAULT null_cvt;

METHOD void * cvt_bwx {
	device_t	dev;
	vm_offset_t	ba;
} DEFAULT null_cvt;

METHOD struct alpha_busspace * get_bustag {
	device_t	dev;
	int		type;
} DEFAULT pci_get_bustag;

METHOD struct rman * get_rman {
	device_t	dev;
	int		type;
} DEFAULT pci_get_rman;
