/* $FreeBSD: src/sys/boot/efi/include/ia64/efibind.h,v 1.6 2005/03/07 15:38:37 stefanf Exp $ */
/*++

Copyright (c) 1998  Intel Corporation

Module Name:

    efefind.h

Abstract:

    EFI to compile bindings




Revision History

--*/

#include <sys/stdint.h>

/* Basic EFI types of various widths. */

typedef uint64_t   UINT64;
typedef int64_t    INT64;
typedef uint32_t   UINT32;
typedef int32_t    INT32;
typedef uint16_t   UINT16;
typedef int16_t    INT16;
typedef uint8_t    UINT8;
typedef int8_t     INT8;


#undef VOID
#define VOID    void


typedef int64_t    INTN;
typedef uint64_t   UINTN;

/*
 *XXX BugBug: Code to debug
 */
#define BIT63   0x8000000000000000

#define PLATFORM_IOBASE_ADDRESS   (0xffffc000000 | BIT63)
#define PORT_TO_MEMD(_Port) (PLATFORM_IOBASE_ADDRESS | ( ( ( (_Port) & 0xfffc) << 10 ) | ( (_Port) & 0x0fff) ) )

/* Macro's with casts make this much easier to use and read. */
#define PORT_TO_MEM8D(_Port)  (*(UINT8  *)(PORT_TO_MEMD(_Port)))
#define POST_CODE(_Data)  (PORT_TO_MEM8D(0x80) = (_Data))

#define EFIERR(a)           (0x8000000000000000 | a)
#define EFI_ERROR_MASK      0x8000000000000000
#define EFIERR_OEM(a)       (0xc000000000000000 | a)      

#define BAD_POINTER         0xFBFBFBFBFBFBFBFB
#define MAX_ADDRESS         0xFFFFFFFFFFFFFFFF

#define BREAKPOINT()        while (TRUE)

/*
 * Pointers must be aligned to these address to function
 *  you will get an alignment fault if this value is less than 8
 */
#define MIN_ALIGNMENT_SIZE  8

#define ALIGN_VARIABLE(Value , Adjustment) \
            (UINTN) Adjustment = 0; \
            if((UINTN)Value % MIN_ALIGNMENT_SIZE) \
                (UINTN)Adjustment = MIN_ALIGNMENT_SIZE - ((UINTN)Value % MIN_ALIGNMENT_SIZE); \
            Value = (UINTN)Value + (UINTN)Adjustment

/*
 * Define macros to create data structure signatures.
 */

#define EFI_SIGNATURE_16(A,B)             ((A) | (B<<8))
#define EFI_SIGNATURE_32(A,B,C,D)         (EFI_SIGNATURE_16(A,B)     | (EFI_SIGNATURE_16(C,D)     << 16))
#define EFI_SIGNATURE_64(A,B,C,D,E,F,G,H) (EFI_SIGNATURE_32(A,B,C,D) | ((UINT64)(EFI_SIGNATURE_32(E,F,G,H)) << 32))

/*
 * To export & import functions in the EFI emulator environment
 */

#define EXPORTAPI

/*
 * EFIAPI - prototype calling convention for EFI function pointers
 * BOOTSERVICE - prototype for implementation of a boot service interface
 * RUNTIMESERVICE - prototype for implementation of a runtime service interface
 * RUNTIMEFUNCTION - prototype for implementation of a runtime function that is not a service
 * RUNTIME_CODE - pragma macro for declaring runtime code    
 */

#ifndef EFIAPI                  /* Forces EFI calling conventions reguardless of compiler options */
#if _MSC_EXTENSIONS
#define EFIAPI __cdecl
#else
#define EFIAPI
#endif
#endif

#define BOOTSERVICE
#define RUNTIMESERVICE
#define RUNTIMEFUNCTION

#define RUNTIME_CODE(a)         alloc_text("rtcode", a)
#define BEGIN_RUNTIME_DATA()    data_seg("rtdata")
#define END_RUNTIME_DATA()      data_seg("")

#define VOLATILE    volatile

/*
 * XXX Need to find out if this is portable across compilers.
 */
void __mf (void);                       
#ifndef __GNUC__
#pragma intrinsic (__mf)  
#endif
#define MEMORY_FENCE()    __mf()

/*
 * When build similiar to FW, then link everything together as
 * one big module.
 */

#define EFI_DRIVER_ENTRY_POINT(InitFunction)

#define LOAD_INTERNAL_DRIVER(_if, type, name, entry)    \
        (_if)->LoadInternal(type, name, entry)

#define INTERFACE_DECL(x) struct x
