/*-
 * Copyright (c) 2007 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#include <stdio.h>
#include <stdlib.h>
#include <sysexits.h>
#include <unistd.h>

#include "procstat.h"

static int aflag, bflag, cflag, fflag, tflag, vflag;
int	hflag;

static void
usage(void)
{

	fprintf(stderr, "usage: procstat [-h] [-a | -b | -c | -f | -t | -v] "
	    "[pid ...]\n");
	exit(EX_USAGE);
}

static void
procstat(pid_t pid)
{

	if (aflag)
		procstat_args(pid);
	else if (bflag)
		procstat_bin(pid);
	else if (cflag)
		procstat_cred(pid);
	else if (fflag)
		procstat_files(pid);
	else if (tflag)
		procstat_threads(pid);
	else if (vflag)
		procstat_vm(pid);
	else
		procstat_basic(pid);
}

int
main(int argc, char *argv[])
{
	long l;
	pid_t pid;
	char *dummy;
	int ch, i, tmp;

	while ((ch = getopt(argc, argv, "abcfhtv")) != -1) {
		switch (ch) {
		case 'a':
			aflag = 1;
			break;

		case 'b':
			bflag = 1;
			break;

		case 'c':
			cflag = 1;
			break;

		case 'f':
			fflag = 1;
			break;

		case 'h':
			hflag = 1;
			break;

		case 't':
			tflag = 1;
			break;

		case 'v':
			vflag = 1;
			break;

		case '?':
		default:
			usage();
		}

	}
	argc -= optind;
	argv += optind;

	tmp = aflag + bflag + cflag + fflag + tflag + vflag;
	if (tmp != 0 && tmp != 1)
		usage();

	if (argc < 1)
		usage();
	for (i = 0; i < argc; i++) {
		l = strtol(argv[i], &dummy, 10);
		if (*dummy != '\0')
			usage();
		if (l < 1)
			usage();
		pid = l;
		procstat(pid);

		/* Suppress header after first process. */
		hflag = 1;
	}
	exit(0);
}
