#!/usr/bin/perl

#
# Read in CSV file, select named columns as data sets for output to
# a .dat file for gnuplot.
#


if ($#ARGV < 2) {
	print "csv2dat.pl infile outfile col [col ...]\n";
	exit -1;
}

$infile = shift(@ARGV);
$outfile = shift(@ARGV);

open(INPUT, "<".$infile) || die $infile;
open(OUTPUT, ">".$outfile) || die $outfile;

@desiredlist = @ARGV;

$_ = <INPUT>;
chop($_);
($month, @datalist) = split(/:/);

#
# Construct a forward index to turn a column number into a column name.
#
for ($i = 0; $i <= $#datalist; $i++) {
	#print "$i: $datalist[$i]\n";
	$datalistindex{$datalist[$i]} = $i;
}

while ($_ = <INPUT>) {
	chop($_);
	($month, @datalistdata) = split(/:/);
	push(@monthlist, $month);
	foreach $desired (@desiredlist) {
		$i = $datalistindex{$desired};
		if (defined($i)) {
			$data{$month}{$desired} = $datalistdata[$i];
		} else {
			$data{$month}{$desired} = 0;
		}
	}
}

print OUTPUT "# ";
for $desired (@desiredlist) {
	print OUTPUT ${desired}." ";
}
print OUTPUT "\n";

for $month (@monthlist) {
	print OUTPUT ${month}." ";
	foreach $desired (@desiredlist) {
		print OUTPUT $data{$month}{$desired}." ";
	}
	print OUTPUT "\n";
}

#foreach $column (@desiredlist) {
#	#print $column.$datalistindex{$column}."\n";
#	print OUTPUT "# ".$column."\n";
#	foreach $month (@monthlist) {
#		if (defined($data{$month}{$column})) {
#			$value = $data{$month}{$column};
#		} else {
#			$value = 0;
#		}
#		print OUTPUT $month." ".${value}."\n";
#	}
#	print OUTPUT "\n";
#}

close(INPUT);
close(OUTPUT);
