/*-
 * Copyright (c) 1999 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *       $Id: $
 */

#include <sys/types.h>
#include <sys/audit.h>
#include <stdio.h>

void try_evid(int event) {
	char	*ch;
	int	i, len;

	printf("   %d -> ", event);
	ch = aud_evid_to_text(event, &len);
	if (!ch) {
		perror("aud_evid_to_text");
		return;
	}
	printf("%s -> ", ch);

	i = aud_evid_from_text(ch);
	if (i == -1) {
		perror("aud_evid_from_text");
		return;
	}
	printf("%d\n", i);

	i = aud_free(ch);
	if (i == -1) {
		perror("aud_free");
		return;
	}
}

void main(void) {
	int	i, event;

	printf("Trying good AUD_AET_* values\n");
	for (event = AUD_AET_FIRST; event <= AUD_AET_LAST; event++) 
		try_evid(event);

	printf("Trying some bad ones\n");
	try_evid(-10);
	try_evid(AUD_AET_FIRST - 1);
	try_evid(AUD_AET_LAST + 1000);
	i = aud_evid_from_text("fred");
	if (i)
		perror("aud_evid_from_text");

	i = aud_evid_from_text("");
	if (i)
		perror("aud_evid_from_text");
	printf("Done.\n");

}
