/*-
 * Copyright (c) 1999 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *       $Id: $
 */

#include <sys/types.h>
#include <sys/audit.h>
#include <err.h>
#include <stdio.h>
#include <unistd.h>

void usage(void) {

	fprintf(stderr, "test [-s on|off|query]\n");
	exit(-1);
}

void main(int argc, char *argv[]) {
	int	i, state;
	extern char *optarg;
	extern int optind;
	int ch;
	
	state = AUD_STATE_QUERY;
	while ((ch = getopt(argc, argv, "s:")) != -1) 
		switch (ch) {
		case 's':
			if (!strcmp(optarg, "on"))
				state=AUD_STATE_ON;
			else
			if (!strcmp(optarg, "off"))
				state=AUD_STATE_OFF;
			else
			if (!strcmp(optarg, "query"))
				state=AUD_STATE_QUERY;
			else
				usage();
			break;
		case '?':
		default:
			usage();
		}

	argc -= optind;
	argv += optind;

	if (state != AUD_STATE_QUERY) {
		i = aud_switch(state);
		if (i == -1) {
			perror("aud_switch");
			exit(-1);
		}
	}

	i = aud_switch(AUD_STATE_QUERY);
	if (i == -1) {
		perror("aud_switch");
		exit(-1);
	}
	switch(i) {
	case AUD_STATE_ON:
		printf("aud_switch: auditing is on\n");
		break;
	case AUD_STATE_OFF:
		printf("aud_switch: auditing is off\n");
		break;
	case AUD_STATE_QUERY:
		printf("aud_switch: auditing is query?\n");
		break;
	default:
		printf("aud_switch: auditing is weird\n");
		break;
	}
}
