/*-
 * Copyright (c) 1999 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *       $Id: $
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/audit.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

extern int optind;

void
usage(foid)
{

	fprintf(stderr, "audit_cat [-f] [logfile]\n");
	exit(-1);
}

void main(int argc, char *argv[]) {
	struct stat	sb;
	aud_rec_t	rec;
	char	*string;
	int	i, filedes, len, follow_flag;
	off_t	filelength;
	char	ch;

	follow_flag = 0;
	while ((ch = getopt(argc, argv, "f")) != -1) {
		switch(ch) {
		case 'f':
			follow_flag = 1;
			break;
		default:
			usage();
		}
	}

	argc -= optind;
	argv += optind;

	if (!argc)
		usage();

	filedes = open(argv[0], O_RDONLY);
	if (filedes == -1) {
		perror("open");
		exit(-1);
	}

	if (follow_flag) {
		while ((rec = aud_read(filedes))) {
			string = aud_rec_to_text(rec, &len);
			if (string) {
				fprintf(stdout, string);
			} else {
				perror("aud_rec_to_text");
			}
		}
	} else {
		i = fstat(filedes, &sb);
		if (i == -1)
			exit(0);
		filelength = sb.st_size;
		while (lseek(filedes, 0, SEEK_CUR) < filelength) {
			rec = aud_read(filedes);
			if (!rec) {
				perror("aud_read");
				exit(-1);
			}
			string = aud_rec_to_text(rec, &len);
			if (string) {
				fprintf(stdout, string);
			} else {
				perror("aud_rec_to_text");
			}
		}
	}
}
