#ifndef lint
static char *rcsid = "$Header: /home/ncvs/posix1e/mac/getfmac/getfmac.c,v 1.2 1999/06/23 11:36:45 ilmar Exp $";
#endif lint

/*
 *	Stat.c		Dump out inode info in nice form.
 *			Original version by someone at Purdue in the days of v6;
 *			this one by Rsk for modern times.
 *
 *			Various enhancements and bugs fixes to this version
 *			by Bill Stoll, Stan Barber, William J. Bogstad,
 *			Michael MacKenzie.
 *
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/mac.h>
#include <ctype.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <locale.h>

#define	FAIL	-1		/* Failure return code from call */	
#define OKAY	0		/* Success return code from call */

struct 	stat	Sbuf;		/* for return values from stat() call */
char	*ctime();		/* Time conversion	*/
struct	passwd	*getpwuid();	/* User entry */
struct	passwd	*pwent;		/* User structure */
struct	group	*getgrgid();	/* Group entry */
struct	group	*grent;		/* Group structure */

char	Mode[10];	/* File protection mode */

#define	LBUFSIZ	256	/* Length for symbolic link translation buffer */
char	Lbuf[LBUFSIZ];	/* Symbolic link translation buffer */

int
main(argc, argv)
int argc;
char *argv[];
{
	register int i;

	(void)setlocale(LC_TIME, "");

	i = 1;

	if(argc == 1) {
		(void) fprintf(stderr,"Usage: %s  [ file2 ... | - ]\n", argv[0]);
		exit(1);
	}
	if(argv[1] == '-') {
		/* get file names from stdin */
	} else {
		do{ (void) getfmac(argv[i]);
		}while(++i < argc);
	}

	exit(0);
}

/*
 * GETFMAC() - get file mac label
 */
int getfmac(filename)
char	*filename;
{
	mac_t	label;
	size_t	llen = 4;
	char	*text;

	label = mac_get_file(filename);
	if(label == NULL) {
		(void) fprintf(stderr,"Can't get mac label of %s\n",filename); 
		return(FAIL);
	} 

	text = mac_to_text(label,&llen);

	if(text == NULL) {
		(void) fprintf(stderr,"Can't get text label of %s\n",filename); 
		return(FAIL);
	} 

	fprintf(stdout,"%s:\t%s\n", filename, text);
	free(text);
	return(OKAY);
	
}

