#ifndef lint
static char *rcsid = "$Header: /home/ncvs/posix1e/mac/getpmac/getpmac.c,v 1.2 1999/06/23 12:10:09 ilmar Exp $";
#endif lint

/*
 *	Stat.c		Dump out inode info in nice form.
 *			Original version by someone at Purdue in the days of v6;
 *			this one by Rsk for modern times.
 *
 *			Various enhancements and bugs fixes to this version
 *			by Bill Stoll, Stan Barber, William J. Bogstad,
 *			Michael MacKenzie.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/mac.h>
#include <ctype.h>
#include <locale.h>

#define	FAIL	-1		/* Failure return code from call */	
#define OKAY	0		/* Success return code from call */

int
main(void)
{
	mac_t	label;
	size_t	llen = 4;
	char	*text;

	(void)setlocale(LC_TIME, "");

	label = mac_get_proc();
	if(label == NULL) {
		perror("Can't get mac label of proc"); 
		return(FAIL);
	} 

	text = mac_to_text(label,&llen);

	if(text == NULL) {
		perror("Can't get text label of proc"); 
		return(FAIL);
	} 

	fprintf(stdout,"%s\n", text);
	free(text);
	return(OKAY);
	
}

