/* Mandatory Access Control new syscalls
 *      -  ,   
 *    .    :
 * 1 -  ,    
 * 2 -      
 * 3 -   System V IPC
 */

#include "opt_posix.h"

#include <sys/param.h>
#include <sys/types.h>
#include <sys/mac.h>
#include <sys/sysproto.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/namei.h>
#include <sys/vnode.h>
#include <sys/file.h>
#include <sys/filedesc.h>
#include <sys/protosw.h>
#include <sys/socketvar.h>
#include <sys/resourcevar.h>
#include <sys/stat.h>
#include <sys/pipe.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/fcntl.h>

#define min(A,B)	(A < B ? A : B)

#include <ufs/ufs/quota.h>
#include <ufs/ufs/inode.h>
#include <miscfs/procfs/procfs.h>
#include <sys/audit.h>


#ifdef _POSIX_MAC

int mac_get_proc_sc(p, uap) /*int mac_get_proc_sc(pmac_t label_p);*/
        struct proc *p;
        register struct mac_get_proc_sc_args *uap;
{
        return (copyout((caddr_t)&p->maclabel.curr_level, uap->label_p, 
		sizeof(mac)));
}

int mac_set_proc_sc(p, uap) /* int mac_set_proc_sc(mac_t label_p);*/
        struct proc *p;
        register struct mac_set_proc_sc_args *uap;
{
	mac	label;
	int	error;

	error = copyin((caddr_t)&label, 
			(caddr_t)uap->label_p,
			sizeof(mac));
	if(error) 
		return (error);
	/* XXX:POSIX.1e dehavior. I'm disagree, but implementing it.*/
	/* Process can encrease its current level up to max level */
	/* NO decreasing rule */

	if(suser(p->p_ucred, &p->p_acflag) == 0) {

		/* ROOT is calling */
		/* XXX: Maybe i should check increasing rule? */
		p->maclabel.max_level = label;
		if(p->maclabel.curr_level > p->maclabel.max_level)
			p->maclabel.curr_level = p->maclabel.max_level;
		return (0);

	} else {
		/* It's if user calls */
		 if((label >= p->maclabel.curr_level) &&
		   (label <= p->maclabel.max_level)) {
			p->maclabel.curr_level = label;
			return 0;
		} else {
		/* XXX: error condition. Should register it*/
			return (EPERM); 
		}
	}
}

/*int mac_get_fd_sc(int fildes, mac_t label_p);*/
int mac_get_fd_sc(p, uap)
        struct proc *p;
        register struct mac_get_fd_sc_args *uap;
{
	struct stat sb;
	int error;
	struct file *fp;
	struct vnode *vp;
	struct socket *so;
	struct pipe *pp;

	/* We must return values not only for vnode, 
	 * but for socket and pipe too
	 */

	switch(fp->f_type) {
	case DTYPE_FIFO:
	case DTYPE_VNODE:
		if (error = getvnode(p->p_fd, uap->fildes, &fp))
			return (error);

		vp = (struct vnode *)fp->f_data; /* XXX ??? */

	/*	error = VOP_ACCESS(vp,VREAD,p->p_ucred, p); 
		if(error) { *//* XXX: error condition - should register it */
	/*		error = EACCES;
			goto return_error;
		}*/

		error = vn_stat(vp, &sb, p);
		vput(vp);
		if (error) {
			goto return_error; 
		/* XXX: maybe we should handle error condition 
	         * according to posix??? */
		}


		error = copyout((caddr_t)&sb.label, (caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	case DTYPE_SOCKET:
		so = (struct socket *)fp->f_data; /* XXX ??? */
		error = copyout((caddr_t)&so->peer.curr_level,
				(caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	case DTYPE_PIPE:
		pp = (struct pipe *)fp->f_data; /* XXX ??? */
		error = copyout((caddr_t)&pp->level,
				(caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	default:
		error = EINVAL;
		break;
	}

return_error:
	return (error);
}

/*int mac_set_fd_sc(int fildes, mac_t label_p);*/
int mac_set_fd_sc(p, uap)
        struct proc *p;
        register struct mac_set_fd_sc_args *uap;
{
	int error;
	struct vattr vattr;
	struct file *fp;
	struct vnode *vp;

	if (error = getvnode(p->p_fd, uap->fildes, &fp))
		return (error);

	vp = (struct vnode *)fp->f_data; /* XXX ??? */

	error = VOP_ACCESS(vp,VREAD,p->p_ucred, p);
	if(error) { 
		error = EACCES;
		goto return_error;
	}

	VOP_LEASE(vp, p, p->p_ucred, LEASE_WRITE);
	vn_lock(vp, LK_EXCLUSIVE | LK_RETRY, p);
	VATTR_NULL(&vattr);

	/* XXX: */
	error = copyin((caddr_t)uap->label_p, (caddr_t)&vattr.va_label, 
			sizeof(mac));
	if(error) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	error = VOP_SETATTR(vp, &vattr, p->p_ucred, p);
	VOP_UNLOCK(vp, 0, p);
	vrele(vp);

return_error:
	return error;
}

/* int mac_get_file_sc(const char *path_p, mac_t label_p);*/
int mac_get_file_sc(p, uap)
        struct proc *p;
        register struct mac_get_file_sc_args *uap;
{
	struct stat sb;
	int error;
	struct nameidata nd;

	NDINIT(&nd, LOOKUP, FOLLOW | LOCKLEAF | NOOBJ, UIO_USERSPACE,
	    uap->path_p, p);

	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	error = vn_stat(nd.ni_vp, &sb, p);
	vput(nd.ni_vp);

	if(error) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	error = copyout((caddr_t)&sb.label, (caddr_t)uap->label_p, 
			sizeof (mac));

return_error:

	return (error);
}

/*int mac_set_file_sc(const char *path_p, mac_t label_p);*/
int mac_set_file_sc(p, uap)
        struct proc *p;
        register struct mac_set_file_sc_args *uap;
{
	int error;
	struct vattr vattr;
	struct nameidata nd;

	NDINIT(&nd, LOOKUP, FOLLOW, UIO_USERSPACE, uap->path_p, p);
	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	VOP_LEASE(nd.ni_vp, p, p->p_ucred, LEASE_WRITE);
	vn_lock(nd.ni_vp, LK_EXCLUSIVE | LK_RETRY, p);
	VATTR_NULL(&vattr);

	/* XXX: */
	error = copyin((caddr_t)uap->label_p, (caddr_t)&vattr.va_label, 
			sizeof(mac));
	if(error) {
		goto return_error;
	}

	error = VOP_SETATTR(nd.ni_vp, &vattr, p->p_ucred, p);
	VOP_UNLOCK(nd.ni_vp, 0, p);
	vrele(nd.ni_vp);

return_error:
	return error;
}

#else /* _POSIX_MAC*/

int mac_set_proc_sc(p, uap) 
        struct proc *p;
        register struct mac_set_proc_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_proc_sc(p, uap)
        struct proc *p;
        register struct mac_get_proc_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_fd_sc(p, uap)
        struct proc *p;
        register struct mac_get_fd_sc_args *uap;
{
	return(ENOSYS);
}

int mac_set_fd_sc(p, uap)
        struct proc *p;
        register struct mac_set_fd_sc_args *uap;
{
	return(ENOSYS);
}

int mac_set_file_sc(p, uap)
        struct proc *p;
        register struct mac_set_file_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_file_sc(p, uap)
        struct proc *p;
        register struct mac_get_file_sc_args *uap;
{
	return(ENOSYS);
}

#endif

#ifdef _POSIX_MAC

int allow_mandatory_access_vnode(p,vp,access)
	struct proc *p;
 	struct vnode *vp;
	int access; 
{
	struct inode *ip;
	struct pfsnode *pfs;
	u_char  objlevel;

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);
	if(vp == NULL) return (TRUE);
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	switch(vp->v_tag) {
		case VT_UFS:
			ip = VTOI(vp);
			objlevel = ip->i_mac_level;
			/*     
			 * .   2  9 - 
			 * floppy disk.  
			 * , ..   
			 * .   
			 *     
			 */
			if(objlevel > 0 )
				if(((major(ip->i_dev) == 9) &&
				    (ip->i_mode & S_IFCHR)) ||
				   ((major(ip->i_dev) == 2) &&
				    (ip->i_mode & S_IFBLK)))
					objlevel = 0;
			break;
		case VT_PROCFS:
			pfs = VTOPFS(vp);
			objlevel = pfs->level;
			break;
		case VT_ISOFS: /* XXX:   cdrom */
			objlevel = 0;
			break;
		case VT_MSDOSFS: /* XXX:   FAT */
			objlevel = 0;
			break;
		case VT_NON: /* XXX:      */
			return (TRUE);
			break;
		default:
printf("vp->v_type, vp->v_tag = %d, %d\n", vp->v_type, vp->v_tag);
			objlevel = 0;
			break;
		}

#ifdef AMAV_DIAGNOSTIC
printf("amav: objlevel = %d, proc = (%s<%d>,%d,%d), access = %d\n",
	(int)objlevel, p->p_comm, p->p_ucred->cr_uid,
	(int)p->maclabel.curr_level, (int)p->maclabel.max_level, access);
#endif

	switch(vp->v_type) {
	case VREG:
	case VFIFO:
	case VLNK:
	case VSOCK: /* XXX: yes??? */
		switch(access) {
		case MWRITE:
			if(p->maclabel.max_level < objlevel) return (FALSE);
			else {  if(p->maclabel.curr_level > objlevel)
					return (FALSE);
				else p->maclabel.curr_level = objlevel;
			}
#ifdef AMAV_DIAGNOSTIC
	printf("amav: return true\n");
#endif
			return (TRUE);
			break;
		case MREAD:
			if(p->maclabel.max_level < objlevel) return (FALSE);
			else if(p->maclabel.curr_level < objlevel)
				p->maclabel.curr_level = objlevel;
#ifdef AMAV_DIAGNOSTIC
	printf("amav: return true\n");
#endif
			return (TRUE);
			break;
		case MMMAPR:
			if(p->maclabel.max_level >= objlevel) {
				if(p->maclabel.curr_level < objlevel)
					p->maclabel.curr_level = objlevel;
				return (TRUE); /* XXX: ??? */
			}
			else return (FALSE);
			break;
		case MMMAPW:
			/*if(p->close_flag & MACMMAPWRITE) return (TRUE);*/
			if((p->maclabel.max_level == 0) && (objlevel == 0))
				return (TRUE);
			return (FALSE);
			break;
		default:
		/* -   */
printf("MFILE VREG VFIFO VLNK access = %d\n", access);
			return (FALSE);
			break;
		}
		return (FALSE);
		break;
	case VDIR:
		switch(access) {
		case MWRITE:
			if(p->maclabel.max_level < objlevel) return (FALSE);
			else return (TRUE);
			break;
		case MREAD:
			if(p->maclabel.max_level < objlevel) return (FALSE);
			else return (TRUE);
			break;
		default:
printf("MFILE DIR access = %d\n", access);
		/* -   */
			return (FALSE);
			break;
		}
		return (FALSE);
		break;
	case VBLK:
	case VCHR:
		switch(access) {
		case MWRITE:
			if(p->maclabel.curr_level > objlevel) return (FALSE);
			else return (TRUE);
		case MREAD:
		case MMMAPR:
/*print("MFILE device mmap with PROT_READ\n");*/
			if(p->maclabel.max_level < objlevel) return (FALSE);
				return (TRUE);
			break;
		case MMMAPW:
/*printf("MFILE device mmap with PROT_WRITE\n");*/
/*      , ..    
 *  -       
 * .     .
 */
			if(p->maclabel.max_level > objlevel) return (FALSE);
			if(p->maclabel.curr_level < objlevel)
				p->maclabel.curr_level = objlevel;
			return (TRUE);
			break;
		default:
printf("MFILE VBLK VCHR access = %d\n", access);
		/* -   */
			return (FALSE);
			break;
		}
		return (TRUE);
		break;
/*	case VSOCK:
printf("allow_mandatory_access: VSOCK\n");
		switch(access) {
		case MREAD:
		case MWRITE:
			if(p->maclabel.curr_level > 0) return (FALSE);
			else return (TRUE);
			break;
		default:
			return (FALSE);
			break;
		}
		break;*/
	default:
printf("amav type %d, access %d\n", vp->v_type, access);
		/* -   */
		return (FALSE);
		break;
	}

	return (FALSE);
}

int allow_mandatory_access_socket(p,so,access)
	struct proc *p;
	struct socket *so;
	int access; 
{
	u_char  objlevel;

	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	/*obj.objecttype = so->so_type;*/
	objlevel = so->peer.curr_level;
/*	if(p->mi.max_level != so->local.max_level) 
		{ so->local.max_level = p->mi.max_level;
		  so->security_flag |= NETCRED_PASSMLEV;
		}
	if(p->mi.curr_level != so->local.curr_level) 
		{ so->local.curr_level = p->mi.curr_level;
		  so->security_flag |= NETCRED_PASSCLEV;
		}
	if(p->p_ucred->cr_uid != so->local.uid)
		{ so->local.uid = p->p_ucred->cr_uid;
		  so->security_flag |= NETCRED_PASSCRED;
		} */
#ifdef AMAS_DIAGNOSTIC
printf("ama so: l(%d,%d)-p(%d,%d) prtcl(%d)\n", /*so->local.uid,*/
so->local.max_level, so->local.curr_level, /*so->peer.uid, */so->peer.max_level,
so->peer.curr_level, so->so_proto->pr_protocol);
#endif
	switch(access) {
		case MREAD:
		case MWRITE:
		case MACCESS:
			if(p->maclabel.curr_level == 0) return (TRUE);
			else return (FALSE);
			break;
		default:
			/* -   */
			printf("allow_mandatory_access: MSOCKET - default\n");
			return (FALSE);
			break;
	}
/*	switch(access) {
	case MREAD:
		if(p->mi.curr_level >= obj.level)
			return (TRUE);
		if(p->mi.max_level >= obj.level) {
			p->mi.curr_level = obj.level;
			return (TRUE);
		}
		else return (FALSE);
		break;
	case MWRITE:
		if(p->mi.curr_level > so->peer.curr_level)
			return (FALSE);
		else return (TRUE);
		break;
	case MACCESS:
		if(p->mi.curr_level == 0) return (TRUE);
		break;
	}*/

	return (FALSE);
}

int allow_mandatory_access_pipe(p,pp,access)
	struct proc *p;
 	struct pipe *pp;
	int access; 
{
	u_char  objlevel;

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	objlevel = pp->level;

#ifdef AMAP_DIAGNOSTIC
printf("amap: access %d, objlevel = %d, proc(%s<%d>,%d,%d)\n", access, objlevel,
	p->p_comm, p->p_ucred->cr_uid, p->maclabel.curr_level,
	p->maclabel.max_level);
#endif

	switch(access) {
	case MREAD:
		if(p->maclabel.max_level < objlevel) return (FALSE);
		else if(p->maclabel.curr_level < objlevel)
			p->maclabel.curr_level = objlevel;
		return (TRUE);
		break;
	case MWRITE:
		if(p->maclabel.max_level < objlevel) return (FALSE);
		else {  if(p->maclabel.curr_level > objlevel)
				return (FALSE);
			else p->maclabel.curr_level = objlevel;
		}
		return (TRUE);
		break;
	default:
	/* -   */
printf(" default5\n");
		return (FALSE);
		break;
	}

	return (FALSE);
}

int allow_mandatory_access(p,fp,access)
	struct proc *p;
 	struct file *fp;
	int access; 
{
	struct ucred *c = p->p_ucred;

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);

	if(suser(c, &p->p_acflag) == 0) return TRUE; /* root   ;-) */

	/*  .     */

	switch(fp->f_type) {
	case DTYPE_FIFO:
	case DTYPE_VNODE:
		return (allow_mandatory_access_vnode(p, (struct vnode *)\
							fp->f_data, access));
		break;
	case DTYPE_SOCKET:
		return (allow_mandatory_access_socket(p, (struct socket *)\
							fp->f_data, access));
		break;
	case DTYPE_PIPE:
		return (allow_mandatory_access_pipe(p, (struct pipe *) \
							fp->f_data, access));
		break;
	}

	/* NOT REACHED */

	return (FALSE);

}

/* Open syscall - operates on vnode */

int allow_mandatory_open_vnode( struct proc *p, struct vnode *vp, int mode)
{
	struct inode *ip;
	mac level;

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);
	if(vp == NULL) return (TRUE);
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	/* root   ;-) */
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	if(vp->v_tag == VT_UFS) {
		ip = VTOI(vp);
		level = ip->i_mac_level;
	}
	else level = 0;

	switch(vp->v_type) {
		case VBLK:
		case VCHR:
		/*        
		 *       . !!!
		 */
				return (TRUE);
				break;
		case VFIFO:
			/* when openning fifo we should have mac write access
			 * to this object
			 */
				if(mode & FWRITE) {
				   if(level < p->maclabel.curr_level)
					return (FALSE);
				   if(level < p->maclabel.max_level)
					p->maclabel.curr_level = level;
				}
				if((mode & FREAD) &&
				   (level > p->maclabel.max_level))
					return (FALSE);
				return (TRUE);
				break;
		case VLNK:
		case VDIR: /* XXX: ??? */
		case VREG:
				/*        
				 *        
				 *     
				 * 
	 			 */
				if((mode & FWRITE) && 
				   (p->maclabel.max_level < level))
					return (FALSE);
				/*        
				 *       
				 *      
				 */
				if((mode & O_TRUNC) &&
				   (p->maclabel.curr_level != level))
					return (FALSE);
				return (TRUE);
				break;
		default:
				return (FALSE); /* XXX: maybe panic > */
	}
}

int allow_mandatory_signal(	struct proc *p,
				struct pcred *pc,
				struct proc *q,
				int signum)
{ 
	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);

 	/* root   */
	if(suser(pc->pc_ucred, &p->p_acflag) == 0) return (TRUE);

	/* if sender dominates reciever 
	 * if(p->maclabel.curr_level > q->maclabel.curr_level) 
	 * _CAP_MAC_WRITE should be present
	 */
	

	/*        */
	/* _CAP_MAC_READ also should be present in case of
         * q dominates p
	 */
	if(p->maclabel.curr_level < q->maclabel.curr_level) 
		return (FALSE);
	/*   .   CANSIGNAL */
	if(pc->p_ruid == q->p_cred->p_ruid || 
		pc->pc_ucred->cr_uid == q->p_cred->p_ruid || 
		pc->p_ruid == q->p_ucred->cr_uid || 
		pc->pc_ucred->cr_uid == q->p_ucred->cr_uid || 
		(signum == SIGCONT && q->p_session == p->p_session))
			return (TRUE);

	/*    */
	return (FALSE);
}

int allow_mandatory_signal_io( ruid, uc, q) 
uid_t	ruid;
struct ucred *uc;
struct proc *q;
{
	if((uc)->cr_uid == 0) return (TRUE); 
	/*        */
	/* _CAP_MAC_READ also should be present in case of
         * q dominates p
	 */
/*	if(p->maclabel.curr_level <= q->maclabel.curr_level) 
		return (FALSE);*/

	if((ruid) == (q)->p_cred->p_ruid || 
	   (uc)->cr_uid == (q)->p_cred->p_ruid || 
	   (ruid) == (q)->p_ucred->cr_uid || 
	   (uc)->cr_uid == (q)->p_ucred->cr_uid)
		return (TRUE);
	else return (FALSE);
}

int allow_mandatory_access_ipc( struct proc *p, caddr_t ipc, int type)
{	
	struct msqid_ds *msqptr;
	struct semid_ds *semaptr;
	int retval = TRUE;

 	/* root   */
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);

	/*    */
/*	if(!mac_enabled) return (TRUE);*/

	switch(type) {
		case MSGGET:
		case MSGCTL:
			msqptr = (struct msqid_ds *)ipc;
			if(p->maclabel.max_level < msqptr->level)
				retval = FALSE;
			break;
		case MSGSND:
		case MSGCTL_IPC_SET:
			msqptr = (struct msqid_ds *)ipc;
			if(p->maclabel.curr_level != msqptr->level)
				retval = FALSE;
			break;
		case MSGCTL_IPC_STAT:
			msqptr = (struct msqid_ds *)ipc;
			if(p->maclabel.curr_level < msqptr->level)
				p->maclabel.curr_level = msqptr->level;
			retval = TRUE;
			break;
		case MSGRCV:
			msqptr = (struct msqid_ds *)ipc;
			if(p->maclabel.max_level < msqptr->level)
				retval = FALSE;
			else {
				if(p->maclabel.curr_level < msqptr->level)
					p->maclabel.curr_level = msqptr->level;
				retval = TRUE;
			}
			break;
		case SEMCTL:
		case SEMGET:
		case SEMOP1:
			semaptr = (struct semid_ds *)ipc;
			if(p->maclabel.max_level < semaptr->level)
				retval = FALSE;
			break;
		case SEMCTL_IPC_SET:
		case SEMCTL_SETVAL:
		case SEMCTL_SETALL:
		case SEMOP2:
			semaptr = (struct semid_ds *)ipc;
			if(p->maclabel.curr_level != semaptr->level)
				retval = FALSE;
			break;
		case SEMCTL_IPC_STAT:
		case SEMCTL_GETPID:
		case SEMCTL_GETVAL:
		case SEMCTL_GETALL:
		case SEMOP3:
			semaptr = (struct semid_ds *)ipc;
			if(p->maclabel.curr_level < semaptr->level)
				p->maclabel.curr_level = semaptr->level;
			retval = TRUE;
			break;
		case SHMAT:
		case SHMCTL:
		case OSHMCTL:
		case SHMGET:
			if(p->maclabel.max_level > 0)
				retval = FALSE;
			break;
		default:
			retval = FALSE;
			break;
	}

	return (retval);

}

#endif /* _POSIX_MAC */
