/*
 *
 * CAPABILITIES implementation
 *
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/capability.h>
#include <sys/audit.h>
#include <sys/mac.h>

		/*    POSIX      SYSTEM  */
cap _cap_max = { { 0xfffffffe, 0xffffffff },  /* effective */
		 { 0xfffffffe, 0xffffffff },  /* inherited */
		 { 0xfffffffe, 0xffffffff }}; /* permited */

#ifdef _POSIX_CAP

/* cap_t	cap_get_fd( int fd ) */
int cap_get_fd_sc( p, uap )
	struct proc *p;
	struct cap_get_fd_sc_args *uap;
{
	int error = 0;
	struct file *fp;
	struct vnode *vp;
	cap caps;

	bzero(&caps,sizeof(cap));

	/* We must return values not only for vnode, 
	 * but for socket and pipe too
	 */

	switch(fp->f_type) {
	case DTYPE_FIFO:
	case DTYPE_VNODE:
		if (error = getvnode(p->p_fd, uap->fildes, &fp))
			break;

		vp = (struct vnode *)fp->f_data; /* XXX ??? */

		error = get_cap(p, vp, &caps);

		break;
	default:
		error = EINVAL;
		break;
	}

	if(!error)
		error = copyout((caddr_t)&caps, (caddr_t)uap->cap_p, 
				sizeof (cap));

	return (error);
}

/* cap_t	cap_get_file( const char *path_p ) */
int cap_get_file_sc( p, uap )
	struct proc p;
	struct cap_get_file_sc_args *uap;
{
	int error = 0;
	struct nameidata nd;
	cap caps;

	bzero(&caps,sizeof(cap));

	NDINIT(&nd, LOOKUP, FOLLOW | LOCKLEAF | NOOBJ, UIO_USERSPACE,
	    uap->path_p, p);

	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	error = get_cap(p,nd.ni_vp,&caps); /* XXX: nd.ni_vp ??? */
	if(error)
		goto return_error;

	error = copyout((caddr_t)&caps, (caddr_t)uap->cap_p, sizeof (cap));

return_error: 

	return (error);
}

/* cap_t	cap_get_proc( void ) */ 
int cap_get_proc_sc( p, uap )
	struct proc *p;
	struct cap_get_proc_sc_args *uap;
{
	int error = 0;

	/* Get capabilities of the process */

	error = copyout((caddr_t)&p->pc_p1ea->caps, 
			uap->cap_p, sizeof(cap));

	return (error);
}

/* int cap_set_fd( int fd, cap_t cap_p ) */
int cap_set_fd_sc( p, uap )
	struct proc *p;
	struct cap_set_fd_args *uap;
{
	int error = 0;
	struct file *fp;
	struct vnode *vp;
	cap caps;

	bzero(&caps,sizeof(cap));

	error = copyin(uap->cap_p, &caps, sizeof(cap));
	if(error)
		goto return_error;

	if (error = getvnode(p->p_fd, uap->fildes, &fp))
		goto return_error;

	vp = (struct vnode *)fp->f_data; /* XXX ??? */

	error = set_cap(p, vp, &caps);

return_error:

	return (error);
}

/* int cap_set_file( const char *path_p, cap_t cap_p ) */
int cap_set_file_sc( p, uap )
	struct proc *p;
	struct cap_set_file_args *uap;
{
	int error = 0;
	struct nameidata nd;
	cap caps;

	bzero(&caps,sizeof(cap));

	error = copyin(uap->cap_p, &caps, sizeof(cap));
	if(error)
		goto return_error;

	NDINIT(&nd, LOOKUP, FOLLOW, UIO_USERSPACE, uap->path_p, p);
	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

/*	error = VOP_SETATTR(nd.ni_vp, &vattr, p->p_ucred, p);*/

	error = set_cap(p,nd.ni_vp,&caps); /* XXX: nd.ni_vp ??? */

	return (error);
}

/* int cap_set_proc( cap_t cap_p ) */
int cap_set_proc_sc( p, uap )
	struct proc *p;
	struct cap_set_proc_args *uap;
{
	int error = 0;

	/* Set Capabilities of the process */

	if(IS_CAP_SET(p,CAP_SETPCAP)) {
		error = copyin((caddr_t)&p->pc_p1ea->caps, 
				uap->cap_p, sizeof(cap));
	} 
	else	{
			/* XXX: I don't know how it would be right, so i'm
			 *	doing it the next way - if permited and
			 *	inherited bits are equal and effective
			 *	bits are dominated or equal to permeited
			 *	then allow to modify the bitset
			 */

			if(IS_CAP_EQUAL(p->pc_p1ea->caps.permited, 
					uap_p->cap_p.permited) &&
			   IS_CAP_EQUAL(p->pc_p1ea->caps.inherited,
					uap_p->cap_p.inherited) &&
			   IS_CAP_EQUAL(p->pc_p1ea->caps.inherited,
					uap_p->cap_p.inherited) &&
			   IS_CAP_SET_ALLOWED(uap_p->cap_p, p->pc_p1ea->caps))

/*				error = copyin((caddr_t)&p->pc_p1ea->caps, 
						uap->cap_p, sizeof(cap));*/
				SET_CAPABILITY(p->pc_p1ea->caps, uap->cap_p);

			else error = (EPERM); 
		}

	return (error);
}

#else /* ! _POSIX_CAP */

/* cap_t	cap_get_fd( int fd ) */
int cap_get_fd_sc( p, uap )
	struct proc *p;
	struct cap_get_fd_sc_args *uap;
{
	return (ENOSYS);
}

/* cap_t	cap_get_file( const char *path_p ) */
int cap_get_file_sc( p, uap )
	struct proc *p;
	struct cap_get_file_sc_args *uap;
{
	return (ENOSYS);
}

/* cap_t	cap_get_proc( void ) */ 
int cap_get_proc_sc( p, uap )
	struct proc *p;
	struct cap_get_proc_sc_args *uap;
{
	return (ENOSYS);
}

/* int cap_set_fd( int fd, cap_t cap_p ) */
int cap_set_fd_sc( p, uap )
	struct proc *p;
	struct cap_set_fd_args *uap;
{
	return (ENOSYS);
}

/* int cap_set_file( const char *path_p, cap_t cap_p ) */
int cap_set_file_sc( p, uap )
	struct proc *p;
	struct cap_set_file_args *uap;
{
	return (ENOSYS);
}

/* int cap_set_proc( cap_t cap_p ) */
int cap_set_proc_sc( p, uap )
	struct proc *p;
	struct cap_set_proc_args *uap;
{
	return (ENOSYS);
}

#endif /* _POSIX_CAP */

#ifdef _POSIX_CAP

int get_cap(p,vp,cap_p)
	struct proc *p;
	struct vnode *vp;
	cap_t cap_p;
{
	int error = 0;

	return (error);
}

int set_cap(p,vp,cap_p)
	struct proc *p;
	struct vnode *vp;
	cap_t cap_p;
{
	int error = 0;

	return (error);
}

#endif
