/* Mandatory Access Control new syscalls
 *      -  ,   
 *    .    :
 * 1 -  ,    
 * 2 -      
 * 3 -   System V IPC
 */

#include "opt_posix.h"

#include <sys/param.h>
#include <sys/types.h>
#include <sys/mac.h>
#include <sys/capability.h>
#include <sys/sysproto.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/namei.h>
#include <sys/vnode.h>
#include <sys/file.h>
#include <sys/filedesc.h>
#include <sys/protosw.h>
#include <sys/socketvar.h>
#include <sys/resourcevar.h>
#include <sys/stat.h>
#include <sys/pipe.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/fcntl.h>

/*#define min(A,B)	(A < B ? A : B)*/

#include <ufs/ufs/quota.h>
#include <ufs/ufs/inode.h>
#include <miscfs/procfs/procfs.h>
#include <sys/audit.h>


#ifdef _POSIX_MAC

mac _mac_label_low;
mac _mac_label_high;

static char compartments[64/8]={0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};

void mac_init(void)
{
	bzero(&_mac_label_low, sizeof(mac));

	_mac_label_high.level = 15;
	bcopy(compartments,&_mac_label_high.compartment,sizeof(compartments));
}

int mac_get_proc_sc(p, uap) /*int mac_get_proc_sc(mac_t label_p);*/
        struct proc *p;
        register struct mac_get_proc_sc_args *uap;
{
	int error = 0;

	/* Getting MAC label of current process */

	error = copyout((caddr_t)&p->pc_p1ea->maclabel, 
			uap->label_p, sizeof(mac));
        return (error);
}

/* Setting MAC label of current process */

int mac_set_proc_sc(p, uap) /* int mac_set_proc_sc(mac_t label_p);*/
        struct proc *p;
        register struct mac_set_proc_sc_args *uap;
{
	int error = 0;
	mac label;

	bzero(&label, sizeof(mac));
	error = copyin(&label, &uap->label_p, sizeof(mac));

	if(!MAC_VALID(label)) {
		error = EINVAL;
		goto return_error;
	}

#ifdef _POSIX_CAP
	if(IS_CAP_SET(p,CAP_MAC_RELABEL_SUBJ)) {
#else
	if(suser(p->p_ucred, &p->p_acflag) == 0) {
#endif
		error = copyin((caddr_t)&p->pc_p1ea->maclabel, 
				&uap->label_p, sizeof(mac));
	} 
	else
		error = (EPERM); 

	return (error);

}

/*int mac_get_fd_sc(int fildes, mac_t label_p);*/
int mac_get_fd_sc(p, uap)
        struct proc *p;
        register struct mac_get_fd_sc_args *uap;
{
	int error = 0;
	struct file *fp;
	struct vnode *vp;
	struct socket *so;
	struct pipe *pp;
	mac label;

	bzero(&label, sizeof(mac));

	/* We must return values not only for vnode, 
	 * but for socket and pipe too
	 */

	switch(fp->f_type) {
	case DTYPE_FIFO:
	case DTYPE_VNODE:
		if (error = getvnode(p->p_fd, uap->fildes, &fp))
			return (error);

		vp = (struct vnode *)fp->f_data; /* XXX ??? */

		error = get_mac_label(p, vp, &label);

		error = copyout((caddr_t)&label, (caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	case DTYPE_SOCKET:
		so = (struct socket *)fp->f_data; /* XXX ??? */
		error = copyout((caddr_t)&so->label,
				(caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	case DTYPE_PIPE:
		pp = (struct pipe *)fp->f_data; /* XXX ??? */
		error = copyout((caddr_t)&pp->label,
				(caddr_t)uap->label_p, 
				sizeof (mac));
		break;
	default:
		error = EINVAL;
		break;
	}

	return (error);
}

/*int mac_set_fd_sc(int fildes, mac_t label_p);*/
int mac_set_fd_sc(p, uap)
        struct proc *p;
        register struct mac_set_fd_sc_args *uap;
{
	int error = 0;
	struct file *fp;
	struct vnode *vp;
	mac label;

	error = copyin(uap->label_p, &label, sizeof(mac));
	if(error) goto return_error;

	if(!MAC_VALID(label)) {
		error = EINVAL;
		goto return_error;
	}

	error = getvnode(p->p_fd, uap->fildes, &fp);
	if(error) goto return_error;

	vp = (struct vnode *)fp->f_data; /* XXX ??? */

	error = set_mac_label(p, vp, &label);

return_error:

	return error;
}

/* int mac_get_file_sc(const char *path_p, mac_t label_p);*/
int mac_get_file_sc(p, uap)
        struct proc *p;
        register struct mac_get_file_sc_args *uap;
{
	int error = 0;
	struct nameidata nd;
	mac label;

	bzero(&label, sizeof(mac));

	NDINIT(&nd, LOOKUP, FOLLOW | LOCKLEAF | NOOBJ, UIO_USERSPACE,
	    uap->path_p, p);

	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

	error = get_mac_label(p,nd.ni_vp,&label); /* XXX: nd.ni_vp ??? */
	if(error)
		goto return_error;

	error = copyout((caddr_t)&label, (caddr_t)uap->label_p, 
			sizeof (mac)); 

return_error: 

	return (error);
}

/*int mac_set_file_sc(const char *path_p, mac_t label_p);*/
int mac_set_file_sc(p, uap)
        struct proc *p;
        register struct mac_set_file_sc_args *uap;
{
	int error = 0;
	struct nameidata nd;
	mac label;

	bzero(&label, sizeof(mac));

	error = copyin(uap->label_p, &label, sizeof(mac));
	if(error) goto return_error;

	if(!MAC_VALID(label)) {
		error = EINVAL;
		goto return_error;
	}

	NDINIT(&nd, LOOKUP, FOLLOW, UIO_USERSPACE, uap->path_p, p);
	if (error = namei(&nd)) {
	/* XXX: maybe we should handle error condition according to posix??? */
		goto return_error;
	}

/*	error = VOP_SETATTR(nd.ni_vp, &vattr, p->p_ucred, p);*/

	error = set_mac_label(p,nd.ni_vp,&label); /* XXX: nd.ni_vp ??? */

return_error: 
	return error;
}

#else /* _POSIX_MAC*/

int mac_set_proc_sc(p, uap) 
        struct proc *p;
        register struct mac_set_proc_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_proc_sc(p, uap)
        struct proc *p;
        register struct mac_get_proc_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_fd_sc(p, uap)
        struct proc *p;
        register struct mac_get_fd_sc_args *uap;
{
	return(ENOSYS);
}

int mac_set_fd_sc(p, uap)
        struct proc *p;
        register struct mac_set_fd_sc_args *uap;
{
	return(ENOSYS);
}

int mac_set_file_sc(p, uap)
        struct proc *p;
        register struct mac_set_file_sc_args *uap;
{
	return(ENOSYS);
}

int mac_get_file_sc(p, uap)
        struct proc *p;
        register struct mac_get_file_sc_args *uap;
{
	return(ENOSYS);
}

#endif

#ifdef _POSIX_MAC

int allow_mandatory_access_vnode(p,vp,access)
	struct proc *p;
 	struct vnode *vp;
	int access; 
{
	mac label;

	bcopy(&_mac_label_low,&label,sizeof(mac));


	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);
	if(vp == NULL) return (TRUE);

#ifdef _POSIX_CAP
	switch(access) {
		case MREAD:	if(IS_CAP_SET(p,CAP_MAC_READ))
					return (TRUE); break;
		case MWRITE:	if(IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
		default:	if(IS_CAP_SET(p,CAP_MAC_READ) && 
				   IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
	}
#else
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);
#endif

/*	switch(vp->v_tag) {
		case VT_UFS:
			ip = VTOI(vp);
			objlevel = ip->i_mac_level;*/
			/*     
			 * .   2  9 - 
			 * floppy disk.  
			 * , ..   
			 * .   
			 *     
			 */
/*			if(objlevel > 0 )
				if(((major(ip->i_dev) == 9) &&
				    (ip->i_mode & S_IFCHR)) ||
				   ((major(ip->i_dev) == 2) &&
				    (ip->i_mode & S_IFBLK)))
					objlevel = 0;
			break;
		case VT_PROCFS:
			pfs = VTOPFS(vp);
			objlevel = pfs->level;
			break;
		case VT_ISOFS: *//* XXX:   cdrom */
/*			objlevel = 0;
			break;
		case VT_MSDOSFS: *//* XXX:   FAT */
/*			objlevel = 0;
			break;
		case VT_NON: *//* XXX:      */
/*			return (TRUE);
			break;
		default:
printf("vp->v_type, vp->v_tag = %d, %d\n", vp->v_type, vp->v_tag);
			objlevel = 0;
			break;
		}

#ifdef AMAV_DIAGNOSTIC
printf("amav: objlevel = %d, proc = (%s<%d>,%d,%d), access = %d\n",
	(int)objlevel, p->p_comm, p->p_ucred->cr_uid,
	(int)p->maclabel.curr_level, (int)p->maclabel.max_level, access);
#endif */

/* XXX: Get maclabel from vnode */

	switch(vp->v_type) {
	case VREG:
	case VDIR:
	case VFIFO:
	case VLNK:
		switch(access) {
		case MWRITE:
/*			if(IS_MAC_DOMINATE(p->pc_p1ea->maclabel,label)) */
			if(MAC_EQUAL(p->pc_p1ea->maclabel,label)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MREAD:
		case MMMAPR:
			if(MAC_DOMINATE(label,p->pc_p1ea->maclabel)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MMMAPW:
			/*if(p->close_flag & MACMMAPWRITE) return (TRUE);*/
			if(MAC_EQUAL(label,_mac_label_low) &&
			   MAC_EQUAL(p->pc_p1ea->maclabel,_mac_label_low)) 
				return (TRUE);
			else return (FALSE);
			break;
		default:
		/* -   */
printf("MFILE VREG VDIR VFIFO VLNK access = %d\n", access);
			return (FALSE);
			break;
		}
		return (FALSE);
		break;
	case VBLK:
	case VCHR:
		switch(access) {
		case MWRITE:
			if(MAC_DOMINATE(p->pc_p1ea->maclabel,label)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MREAD:
		case MMMAPR:
printf("MFILE device mmap with PROT_READ\n");
			if(MAC_DOMINATE(label,p->pc_p1ea->maclabel)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MMMAPW:
printf("MFILE device mmap with PROT_WRITE\n");
/*      , ..    
 *  -       
 * .     .
 */
			if(MAC_EQUAL(p->pc_p1ea->maclabel,label)) 
				return (TRUE);
			else return (FALSE);
			break;
		default:
printf("MFILE VBLK VCHR access = %d\n", access);
		/* -   */
			return (FALSE);
			break;
		}
		return (FALSE);
		break;
	case VSOCK:
printf("allow_mandatory_access: VSOCK\n");
		switch(access) {
		case MREAD:
		case MWRITE:
			if(MAC_EQUAL(label,_mac_label_low) &&
			   MAC_EQUAL(p->pc_p1ea->maclabel,_mac_label_low)) 
				return (TRUE);
			else return (FALSE);
			break;
		default:
			return (FALSE);
			break;
		}
		break;
	default:
printf("amav type %d, access %d\n", vp->v_type, access);
		/* -   */
		return (FALSE);
		break;
	}

	return (FALSE);
}

int allow_mandatory_access_socket(p,so,access)
	struct proc *p;
	struct socket *so;
	int access; 
{
	mac label;

	bcopy(&_mac_label_low,&label,sizeof(mac));

#ifdef _POSIX_CAP
	switch(access) {
		case MREAD:	if(IS_CAP_SET(p,CAP_MAC_READ))
					return (TRUE); break;
		case MWRITE:	if(IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
		default:	if(IS_CAP_SET(p,CAP_MAC_READ) && 
				   IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
	}
#else
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);
#endif
	/* XXX: get mac label of socket */
	switch(access) {
		case MWRITE:
/*			if(MAC_DOMINATE(p->pc_p1ea->maclabel,label)) */
			if(MAC_EQUAL(p->pc_p1ea->maclabel,label)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MREAD:
			if(MAC_DOMINATE(label,p->pc_p1ea->maclabel)) 
				return (TRUE);
			else return (FALSE);
			break;
		default: return (FALSE);
			 break;
	}

	return (FALSE); /* XXX: If label != sys_low -> return false */
}

int allow_mandatory_access_pipe(p,pp,access)
	struct proc *p;
 	struct pipe *pp;
	int access; 
{
	mac label;

	bcopy(&_mac_label_low,&label,sizeof(mac));

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);

#ifdef _POSIX_CAP
	switch(access) {
		case MREAD:	if(IS_CAP_SET(p,CAP_MAC_READ))
					return (TRUE); break;
		case MWRITE:	if(IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
		default:	if(IS_CAP_SET(p,CAP_MAC_READ) && 
				   IS_CAP_SET(p,CAP_MAC_WRITE))
					return (TRUE); break;
	}
#else
	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);
#endif
	/* XXX: get mac label of socket */
	switch(access) {
		case MWRITE:
/*			if(MAC_DOMINATE(p->pc_p1ea->maclabel,label)) */
			if(MAC_EQUAL(p->pc_p1ea->maclabel,label)) 
				return (TRUE);
			else return (FALSE);
			break;
		case MREAD:
			if(MAC_DOMINATE(label,p->pc_p1ea->maclabel)) 
				return (TRUE);
			else return (FALSE);
			break;
		default: return (FALSE);
			 break;
	}

	return (FALSE); /* XXX: If label != sys_low -> return false */


/*#ifdef AMAP_DIAGNOSTIC
printf("amap: access %d, objlevel = %d, proc(%s<%d>,%d,%d)\n", access, objlevel,
	p->p_comm, p->p_ucred->cr_uid, p->maclabel.curr_level,
	p->maclabel.max_level);
#endif*/

	return (FALSE);
}

int allow_mandatory_access(p,fp,access)
	struct proc *p;
 	struct file *fp;
	int access; 
{
	/* XXX: hack for kernel threads execution 
	if(p == NULL) return (TRUE); */

	/*  .     */

	switch(fp->f_type) {
	case DTYPE_FIFO:
	case DTYPE_VNODE:
		return (allow_mandatory_access_vnode(p, (struct vnode *)\
							fp->f_data, access));
		break;
	case DTYPE_SOCKET:
		return (allow_mandatory_access_socket(p, (struct socket *)\
							fp->f_data, access));
		break;
	case DTYPE_PIPE:
		return (allow_mandatory_access_pipe(p, (struct pipe *) \
							fp->f_data, access));
		break;
	}

	/* NOT REACHED */

	return (FALSE);

}

/* Open syscall - operates on vnode */

int allow_mandatory_open_vnode( struct proc *p, struct vnode *vp, int mode)
{
	mac label;

/* I don't know if this procedure is needed right now. It was developed for
 * floating labels.
 */

	return (TRUE);

	bcopy(&_mac_label_low,&label,sizeof(mac));

	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);
	if(vp == NULL) return (TRUE);


/*	switch(vp->v_type) {
		case VBLK:
		case VCHR:*/
		/*        
		 *       . !!!
		 */
/*				return (TRUE);
				break;
		case VFIFO:*/
			/* when openning fifo we should have mac write access
			 * to this object
			 */
			/*	if(mode & FWRITE) {
				   if(level < p->maclabel.curr_level)
					return (FALSE);
				   if(level < p->maclabel.max_level)
					p->maclabel.curr_level = level;
				}
				if((mode & FREAD) &&
				   (level > p->maclabel.max_level))
					return (FALSE);
				return (TRUE);
				break;
		case VLNK:
		case VDIR: *//* XXX: ??? */
/*		case VREG:*/
				/*        
				 *        
				 *     
				 * 
	 			 */
			/*	if((mode & FWRITE) && 
				   (p->maclabel.max_level < level))
					return (FALSE);*/
				/*        
				 *       
				 *      
				 */
/*				if((mode & O_TRUNC) &&
				   (p->maclabel.curr_level != level))
					return (FALSE);
				return (TRUE);
				break;
		default:
				return (FALSE); *//* XXX: maybe panic > */
/*	}*/

	return (FALSE);
}

int allow_mandatory_signal(	struct proc *p,
				struct pcred *pc,
				struct proc *q,
				int signum)
{ 
	/* XXX: hack for kernel threads execution */
	if(p == NULL) return (TRUE);

	/* rule 1 */
	/* labelp == labelq */
	if(MAC_EQUAL(p->pc_p1ea->maclabel, q->pc_p1ea->maclabel))
		goto std_signal;

	/* rule 2 */
	/* labelp dominates labelq */
	if(MAC_DOMINATE(q->pc_p1ea->maclabel,p->pc_p1ea->maclabel))
		goto std_signal;

	/* rule 3 */
	/* labelq dominates labelp - requires privs. CAP_MAC_READ */
	if(MAC_DOMINATE(p->pc_p1ea->maclabel,q->pc_p1ea->maclabel)) {
#ifdef _POSIX_CAP
		if(IS_CAP_SET(p,CAP_MAC_READ))
		/* if(IS_CAP_SET(q,CAP_MAC_READ)) */
#else
		if(suser(p->p_ucred, &p->p_acflag) == 0)
#endif	 
			goto std_signal;	
		else return (EPERM);
	}
	/* rule 4 */
/*	if(!MAC_DOMINATE(p->pc_p1ea->maclabel,q->pc_p1ea->maclabel) &&
	   !MAC_DOMINATE(p->pc_p1ea->maclabel,q->pc_p1ea->maclabel)) {
	}*/
#ifdef _POSIX_CAP
	if(!IS_CAP_SET(p,CAP_MAC_WRITE))
#else
	if(suser(p->p_ucred, &p->p_acflag) != 0)
#endif	 
		return (EPERM);


std_signal:
	/*   .   CANSIGNAL */
	if(pc->p_ruid == q->p_cred->p_ruid || 
		pc->pc_ucred->cr_uid == q->p_cred->p_ruid || 
		pc->p_ruid == q->p_ucred->cr_uid || 
		pc->pc_ucred->cr_uid == q->p_ucred->cr_uid || 
		(signum == SIGCONT && q->p_session == p->p_session))
			return (TRUE);

	/*    */
	return (FALSE);
}

int allow_mandatory_signal_io( ruid, uc, q) 
uid_t	ruid;
struct ucred *uc;
struct proc *q;
{
/*	if((uc)->cr_uid == 0) return (TRUE); */
	/*        */
	/* _CAP_MAC_READ also should be present in case of
         * q dominates p
	 */
/*	if(p->maclabel.curr_level <= q->maclabel.curr_level) 
		return (FALSE);*/

/*	if((ruid) == (q)->p_cred->p_ruid || 
	   (uc)->cr_uid == (q)->p_cred->p_ruid || 
	   (ruid) == (q)->p_ucred->cr_uid || 
	   (uc)->cr_uid == (q)->p_ucred->cr_uid)
		return (TRUE);
	else return (FALSE);*/
	return (TRUE);
}

int allow_mandatory_access_ipc( struct proc *p, caddr_t ipc, int type)
{	
	int retval = FALSE;
	struct msqid_ds *msqptr;
	struct semid_ds *semaptr;

 	/* root   */
/*	if(suser(p->p_ucred, &p->p_acflag) == 0) return (TRUE);*/

	/*    */
/*	if(!mac_enabled) return (TRUE);*/

	switch(type) {
		case MSGGET:
		case MSGCTL:
		case MSGCTL_IPC_STAT:
			msqptr = (struct msqid_ds *)ipc;
			if(MAC_DOMINATE(msqptr->label,p->pc_p1ea->maclabel))
				retval = TRUE;
			break;
		case MSGSND:
		case MSGCTL_IPC_SET:
		case MSGRCV:
			msqptr = (struct msqid_ds *)ipc;
			if(MAC_EQUAL(msqptr->label,p->pc_p1ea->maclabel))
				retval = TRUE;
			break;
		case SEMCTL:
		case SEMGET:
		case SEMOP1:
		case SEMOP3:
		case SEMCTL_IPC_STAT:
		case SEMCTL_GETPID:
		case SEMCTL_GETVAL:
		case SEMCTL_GETALL:
			semaptr = (struct semid_ds *)ipc;
			if(MAC_DOMINATE(semaptr->label,p->pc_p1ea->maclabel))
				retval = TRUE;
			break;
		case SEMCTL_IPC_SET:
		case SEMCTL_SETVAL:
		case SEMCTL_SETALL:
		case SEMOP2:
			semaptr = (struct semid_ds *)ipc;
			if(MAC_EQUAL(semaptr->label,p->pc_p1ea->maclabel))
				retval = TRUE;
			break;
		case SHMAT:
		case SHMCTL:
		case OSHMCTL:
		case SHMGET:
			if(MAC_EQUAL(p->pc_p1ea->maclabel, _mac_label_low))
				retval = TRUE;
			break;
		default:
			retval = FALSE;
			break;
	} 

	return (retval);

}

int get_mac_label(p,vp,label_p)
	struct proc *p;
	struct vnode *vp;
	mac_t label_p;
{	
	int error = 0;

	bcopy(&_mac_label_low,label_p,sizeof(mac));

	error = VOP_ACCESS(vp,VREAD,p->p_ucred, p); 
	if(error) { /* XXX: error condition - should register it */
		error = EACCES;
		goto return_error;
	}

/*	XXX: here must be the code which gets mac label from the vnode */
/*	error = vn_stat(vp, &sb, p); */
	vput(vp);

return_error:

	return (error);

}

int set_mac_label(p,vp,label_p)
	struct proc *p;
	struct vnode *vp;
	mac_t label_p;
{	
	int error = 0;
	mac oldlabel;
	mac newlabel;

	bcopy(&_mac_label_low,&oldlabel,sizeof(mac));
	bcopy(label_p,&newlabel,sizeof(mac));

	error = VOP_ACCESS(vp,VREAD,p->p_ucred, p);
	if(error) { 
		error = EACCES;
		goto return_error;
	}

	VOP_LEASE(vp, p, p->p_ucred, LEASE_WRITE);
	vn_lock(vp, LK_EXCLUSIVE | LK_RETRY, p);

#ifdef _POSIX_CAP
	/* 1. Get file label */

	/* error = get_maclabel_vnode(); */

	/* 2. If oldlabel dominates newlabel
		if(IS_CAP_SET(p,CAP_MAC_DOWNGRADE))
			allow;
		else deny; */
	
	if(MAC_DOMINATE(newlabel, oldlabel) && IS_CAP_SET(p,CAP_MAC_DOWNGRADE))
		goto set_label;

	/* 3. else if newlabel dominates oldlabel
		if(IS_CAP_SET(p,CAP_MAC_UPGRADE))
			allow;
		else deny; */
	if(MAC_DOMINATE(oldlabel, newlabel) && IS_CAP_SET(p,CAP_MAC_UPGRADE))
		goto set_label;
	/* 4. I don't know what to do with no domination situation 
	   Maybe use both capabilities? */
	if(IS_CAP_SET(p,CAP_MAC_UPGRADE) && IS_CAP_SET(p,CAP_MAC_DOWNGRADE))
		goto set_label;
	else {
		error = EPERM;
		goto return_error;
	}
#else
	if(suser(p->p_ucred, &p->p_acflag) != 0) {
		error = EPERM;
		goto return_error;
	}
#endif

set_label:
	/* XXX: */

/*	error = VOP_SETATTR(vp, &vattr, p->p_ucred, p); */
	VOP_UNLOCK(vp, 0, p);
	vrele(vp);

return_error:

	return (error);

}

#endif /* _POSIX_MAC */
