/*
 *
 * POSIX 1E main implementation file
 *
 */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/malloc.h>
#include <sys/posix1e.h>

MALLOC_DEFINE(M_POSIX1EATTR, "posix1eattr", "MAC labels and capabilities");

/* This structure is like p_cred in proc */
/*struct posix1e_attr {
	u_int	refcount;
	mac 	maclabel;
	cap	caps; 
};*/

/* Create new structure */
struct posix1e_attr * p1ea_malloc (void)
{
	register struct posix1e_attr *a_p = NULL;

	MALLOC(a_p, struct posix1e_attr *, sizeof(struct posix1e_attr), 
		M_POSIX1EATTR, M_WAITOK);
	if(a_p == NULL) return (NULL);
/*	bzero(a_p, sizeof(struct posix1e_attr)); */
	a_p->refcount = 1;
/*printf("p1ea_malloc: a_p->refcount=%d\n", a_p->refcount);*/
	return (a_p);
}

/* delete old structure */
void p1ea_free (struct posix1e_attr *free_p)
{
/*printf("p1ea_free: refcount=%d\n", free_p->refcount);*/
	if (--free_p->refcount == 0)
		FREE((caddr_t)free_p, M_POSIX1EATTR);
}

/* copy struture contents */
void p1ea_copy (struct posix1e_attr *a_p, struct posix1e_attr *b_p)
{
/*	*b_p = *a_p; */
/*printf("p1ea_copy: a_p->refcount=%d\n", a_p->refcount);*/
	bcopy(a_p, b_p, sizeof(struct posix1e_attr));
	b_p->refcount = 1;
/*printf("p1ea_copy: b_p->refcount=%d\n", b_p->refcount);*/
}

