/*-
 * Copyright (c) 1999 Ilmar S. Habibulin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *       $Id: mac.h,v 1.5 1999/06/23 07:29:12 ilmar Exp $
 */

#ifndef _SYS_MAC_H_
#define _SYS_MAC_H_

#include <sys/types.h>

#define MREAD	1
#define MWRITE	2
#define MACCESS 3
#define MMMAPR	4 /* mmap with READ protection */
#define MMMAPW	5 /* mmap with WRITE protection */
#define MEXEC	MREAD
#define MSEARCH	MREAD

/* System V IPC */
#define MSGCTL		1
#define MSGCTL_IPC_SET	2
#define MSGCTL_IPC_STAT	3
#define MSGGET		4
#define MSGSND		5
#define MSGRCV		6
#define SEMCTL		7
#define SEMCTL_IPC_SET	8
#define SEMCTL_IPC_STAT	9
#define SEMCTL_GETPID	10
#define SEMCTL_GETVAL	11
#define SEMCTL_GETALL	12
#define SEMCTL_SETVAL	13
#define SEMCTL_SETALL	14
#define SEMGET		15
#define SEMOP1		16
#define SEMOP2		17
#define SEMOP3		18
#define SHMAT		19
#define SHMCTL		20
#define OSHMCTL		21
#define SHMGET		22

#define MAC_SYS_LOW	_mac_label_low
#define MAC_SYS_HIGH	_mac_label_high
#define MAC_SYS_EMPTY	(-1)

/* true if label (b) dominates label (a) */
#define MAC_DOMINATE(a,b) \
	((a.level <= b.level) && \
	 ((a.compartment & b.compartment) == a.compartment))

#define _MAC_DOMINATE(a,b) \
	((a->level <= b->level) && \
	 ((a->compartment & b->compartment) == a->compartment))

/* true if label (a) is equal to label (b) */
#define MAC_EQUAL(a,b) \
	((a.level == b.level) && \
	 !bcmp(&a.compartment,&b.compartment,sizeof(u_int64_t)))

#define _MAC_EQUAL(a,b) \
	((a->level == b->level) && \
	 !bcmp(&a->compartment,&b->compartment,sizeof(u_int64_t)))

/* define validity of mac label */
#define MAC_VALID(a) \
	(a.level < 0x10)

#define _MAC_VALID(a) \
	(a->level < 0x10)

struct proc;
struct file;
struct pipe;
struct vnode;
struct socket;
struct pcred;
struct ucred;

/*typedef unsigned char mac;
typedef mac * mac_t;

struct proc_mac_label {
	mac max_level;
	mac curr_level;
};

typedef struct proc_mac_label pmac;
typedef pmac * pmac_t; */

/*
 * New MAC label implementation
 *
 */

struct _mac_label {
	u_char	  level;	/* sensivity level - hierarchical category */
	u_int64_t compartment;	/* compartment - non-hierarchical category */
};

/* But only 4 low bits are used for level. Others are reserved for use in
 * Biba integrety model implementation - future use 
 */

typedef struct _mac_label mac;
typedef mac * mac_t;

extern mac _mac_label_low;
extern mac _mac_label_high;


#ifdef _POSIX_MAC
/*
 * These are the access functions described in POSIX.1E
 */

#ifndef KERNEL
/* 26.3 Functions */

int	mac_dominate(mac_t labela, mac_t labelb); // libposix1e
int	mac_equal(mac_t labela, mac_t labelb); // libposix1e
int	mac_free(void *buf_p); // libposix1e
mac_t	mac_from_text(const char *text_p); // libposix1e
mac_t	mac_get_fd(int fildes); // kernel
mac_t	mac_get_file(const char *path_p); // kernel
mac_t	mac_get_proc(void); // kernel
mac_t	mac_glb(mac_t labela, mac_t labelb); // ??? libposix1e
mac_t	mac_lub(mac_t labela, mac_t labelb); // ??? libposix1e
int	mac_set_fd(int fildes, mac_t label); // kernel
int	mac_set_file(const char *path_p, mac_t label); // kernel
int	mac_set_proc(mac_t label); // kernel
ssize_t	mac_size(mac_t label); // ??? libposix1e
char *	mac_to_text(mac_t label, size_t *len_p); // libposix1e
int	mac_valid(mac_t label); // libposix1e


#else /* KERNEL */

	/* ,       */
int  allow_mandatory_access (struct proc *, struct file *, int);
int  allow_mandatory_access_vnode (struct proc *, struct vnode *, int);
int  allow_mandatory_access_socket (struct proc *, struct socket *, int);
int  allow_mandatory_access_pipe (struct proc *, struct pipe *, int);
int  allow_mandatory_open_vnode (struct proc *, struct vnode *, int);
int  allow_mandatory_open_socket (struct proc *, struct socket *, int); 
int  allow_mandatory_access_ipc (struct proc *, caddr_t, int);
int  allow_mandatory_signal(struct proc *, struct pcred *, struct proc *, int);
int  allow_mandatory_signal_io( uid_t, struct ucred *, struct proc *);
void mac_init(void);
int  get_mac_label(struct proc *, struct vnode *, mac_t);
int  set_mac_label(struct proc *, struct vnode *, mac_t);

#endif /* KERNEL */

#else /* _POSIX_MAC */

#ifdef KERNEL
#endif /* KERNEL */

#endif /* _POSIX_MAC */
#endif /* _SYS_MAC_H_ */
