%{

/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: implementation.y,v 1.2 1998/07/13 22:35:15 robert Exp $
 */

#include <string.h>
#include <stdio.h>

#include "types.h"
#include "const.h"
#include "globals.h"

extern void implementationerror(char *s);


%}

%union {
	struct implstr *impl;
	char *string;
}

%token <string> QUOTED_STRING DEFAULT_STRING BAD_TOKEN_STRING
%type <impl> impl

%%
start: impl
		{
			topimpl = $1;
			if (parse_debug) 
				fprintf(stderr, "top impl defined\n");
		}
impl: /* empty */
		{
			$$ = 0;
			if (parse_debug)
				fprintf(stderr, "end impl\n");
		}
|	QUOTED_STRING DEFAULT_STRING ';' impl
		{
			$$ = (struct implstr *)
				malloc(sizeof(struct implstr));
			$$->setname = $1;
			$$->level = strdup(DEFAULT_DECLARE_STRING);
			$$->next = $4;
			if (parse_debug)
				fprintf(stderr, "impl: set '%s' assigned level "
					"'%s'\n", $$->setname, $$->level);
		}
|	QUOTED_STRING QUOTED_STRING ';' impl
		{
			$$ = (struct implstr *)
                                malloc(sizeof(struct implstr));
                        $$->setname = $1;
                        $$->level = $2;
			$$->next = $4;
                        if (parse_debug)
                                fprintf(stderr, "impl: set '%s' assigned level "
                                        "'%s'\n", $$->setname, $$->level);
                }
;

%%

int implementationwrap(void) {
	return(1);
}
	

