/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: statfile.c,v 1.1 1998/07/15 15:24:34 robert Exp $
 */

/* generate a quick default policy entry for file[s] on the command line */

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <stdio.h>


int main(int argc, char *argv[]) {
	struct stat sb;
	struct passwd *p;
	struct group *g;
	int i, err;

	if (argc<=1) {
		fprintf(stderr, "statfile [file...]\n");
		return(0);
	}

	for (i=1; i<argc; i++) {
		err = stat(argv[i], &sb);
		if (err) {
			perror(argv[i]);
		} else {
			printf("\tfile \"%s\" {\n", argv[i]);
			printf("\t\tmode default \"%o\";\n", 
				(sb.st_mode & ~S_IFMT));
			p = getpwuid(sb.st_uid);
			g = getgrgid(sb.st_gid);
			if (p) {
				printf("\t\towner default \"%s\";\n",
					p->pw_name);
			} else {
				printf("\t\towner default \"%d\";\n",
					sb.st_uid);
			}
			if (g) {
				printf("\t\tgroup default \"%s\";\n",
					g->gr_name);
			} else {
				printf("\t\tgroup default \"%d\";\n",
					sb.st_gid);
			}
			printf("\t};\n");
		}
	}
	return(0);
}
		
