%{

/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: implementation.l,v 1.2 1998/07/13 22:35:15 robert Exp $
 */

#include <string.h>
#include <stdio.h>
#include "implementation.yacc.h"
#include "types.h"
#include "const.h"
#include "globals.h"

static int line=1;

void implementationerror(char *s);
void implementationwarn(char *s);

#define TRIM_QUOTED_STRING(x) { x++; x[strlen(x)-1] = '\0'; }

%}

%s BADTOKEN

default "default"

%%

<BADTOKEN>[^ \t\n]+     { implementationlval.string = yytext;
                  implementationerror("unrecognized token");
                  return BAD_TOKEN_STRING; }
\"[^"\n]*["\n]  { implementationlval.string = strdup(yytext);
                  TRIM_QUOTED_STRING(implementationlval.string);
                  return QUOTED_STRING; }
{default} 	{ implementationlval.string = notstring;
		  return DEFAULT_STRING; }
";"		{ implementationlval.string = notstring;
		  return ';'; }
[ \t]           { implementationlval.string = notstring; }
\n              { implementationlval.string = notstring;
                  line++; }
<<EOF>>		{ return 0; }
.		{ BEGIN BADTOKEN; unput(implementationtext[0]); }
%%


void implementationerror(char *s) {
	fprintf(stderr, "%s:%d: %s at '%s'\n", source, line, s,
		implementationtext);
}

void implementationwarn(char *s) {
        fprintf(stderr, "%s:%d: %s at '%s'\n", source, line, s,
                implementationtext);
}

