%{

/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: policy.l,v 1.3 1998/07/13 22:35:16 robert Exp $
 */

#include <string.h>
#include <stdio.h>
#include "policy.yacc.h"
#include "types.h"
#include "const.h"
#include "globals.h"

static int line=1;

void policyerror(char *s);
void policywarn(char *s);

#define TRIM_QUOTED_STRING(x) { x++; x[strlen(x)-1] = '\0'; }

%}

%s COMMENT
%s BADTOKEN

default "default"

%%

<COMMENT>"*/"	{ BEGIN 0; }
<COMMENT>[^*\n]+	{ ; }
<COMMENT>"*"+		{ ; }
<COMMENT>\n	{ line++; }
<BADTOKEN>[^ \t\n]+	{ policylval.string = yytext;
		  policyerror("unrecognized token");
		  return BAD_TOKEN_STRING; }
"/*" { BEGIN COMMENT; }
"{"		{ policylval.string = notstring;
		  return '{'; }
"}"		{ policylval.string = notstring;
		  return '}'; }
\"[^"\n]*["\n]	{ policylval.string = strdup(yytext);
		  TRIM_QUOTED_STRING(policylval.string);
		  return QUOTED_STRING; }
"set"		{ policylval.string = notstring;
		  return SET_STRING; }
"comment"	{ policylval.string = notstring;
		  return COMMENT_STRING; }
"declare"       { policylval.string = notstring;
		  return DECLARE_STRING; }
"level"		{ policylval.string = notstring;
		  return LEVEL_STRING; }
"file"		{ policylval.string = notstring;
		  return FILE_STRING; }
"mode"          { policylval.string = notstring;
		  return MODE_STRING; }
"owner"		{ policylval.string = notstring;
		  return OWNER_STRING; }
"group"		{ policylval.string = notstring;
		  return GROUP_STRING; }
{default}	{ policylval.string = notstring;
		  return DEFAULT_STRING; }
"new"		{ policylval.string = notstring;
		  return NEW_STRING; }
";"	 	{ policylval.string = notstring;
		  return ';'; }
[ \t]		{ policylval.string = notstring; }
\n		{ policylval.string = notstring;
		  line++; }
<<EOF>>		{ return 0; }
.		{ BEGIN BADTOKEN; unput(policytext[0]); }
%%

void policyerror(char *s) {
        fprintf(stderr, "%s:%d: %s at '%s'\n", source, line, s, policytext);
}

void policywarn(char *s) {
	fprintf(stderr, "%s:%d: %s at '%s'\n", source, line, s, policytext);
}


