%{
/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: policy.y,v 1.3 1998/07/13 22:35:16 robert Exp $
 */

#include <string.h>
#include <stdio.h>

#include "types.h"
#include "const.h"
#include "globals.h"

extern void policyerror(char *s);


%}

%union {
	struct setstr *set;
	struct setbodystr *setbody;
	struct filebodystr *filebody;
	char *string;
}

%token <string> SET_STRING QUOTED_STRING COMMENT_STRING FILE_STRING
%token <string> MODE_STRING OWNER_STRING GROUP_STRING DEFAULT_STRING NEW_STRING
%token <string> BAD_TOKEN_STRING DECLARE_STRING LEVEL_STRING
%type <set> set
%type <setbody> setbody
%type <filebody> filebody

%%
start: set
		{
			topset = $1;
			if (parse_debug) {
				fprintf(stderr, "top set defined\n");
			}
		}
;
set: /* empty */ 
		{
			$$ = 0;
			if (parse_debug)
				fprintf(stderr, "end of set definitions\n");
		}
|	SET_STRING QUOTED_STRING '{' setbody '}' ';' set
		{
			$$ = (struct setstr *)
				malloc(sizeof(struct setstr));
			$$->name = $2;
			$$->setbody = $4;
			$$->next = $7;

			$$->files = $$->declares = $$->comments = 0;
			$$->chosen_level = 0;

			if (parse_debug)
				fprintf(stderr, "set '%s' defined\n", $2);
		}
;
setbody: /* empty */ 
		{
			$$ = 0;
			if (parse_debug)
				fprintf(stderr, "end setbody\n");
		}
|        COMMENT_STRING QUOTED_STRING ';' setbody 
		{
			$$ = (struct setbodystr *)
				malloc(sizeof(struct setbodystr));
			$$->commentstring = $2;
			$$->filename = 0;
			$$->filebody = 0;
			$$->declare = 0;
			$$->next = $4;
			if (parse_debug)
				fprintf(stderr, "comment setbody defined\n");
		}
|	DECLARE_STRING LEVEL_STRING QUOTED_STRING QUOTED_STRING ';' setbody
		{
			$$ = (struct setbodystr *)
				malloc(sizeof(struct setbodystr));
			$$->commentstring = 0;
			$$->filename = 0;
			$$->filebody = 0;
			$$->declare = (struct declarestr *)
				malloc(sizeof(struct declarestr));
			$$->declare->name = $3;
			$$->declare->commentstring = $4;
			$$->next = $6;
			if (parse_debug)
				fprintf(stderr, "level declaration defined\n");
		}
|       FILE_STRING QUOTED_STRING '{' filebody '}' ';' setbody
		{
			$$ = (struct setbodystr *)
				malloc(sizeof(struct setbodystr));
			$$->commentstring = 0;
			$$->filebody = $4;
			$$->filename = $2;
			$$->declare = 0;
			$$->next = $7;
			if (parse_debug)
				fprintf(stderr, "file setbody defined\n");
		}
;
filebody: /* empty */
		{
			$$ = 0;
			if (parse_debug)
				fprintf(stderr, "end filebody\n");
		}
|	COMMENT_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_COMMENT;
			$$->value = $2;
			$$->level = 0;
			$$->next = $4;
			if (parse_debug)
					fprintf(stderr, "file comment defined\n");
		}
|	MODE_STRING DEFAULT_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_MODE;
			$$->value = $3;
			$$->level = strdup(DEFAULT_DECLARE_STRING);
			$$->next = $5; 
			if (parse_debug)
				fprintf(stderr, "file old mode defined\n");
		}
|	MODE_STRING QUOTED_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_MODE;
			$$->value = $3;
			$$->level = $2;
			$$->next = $5;
			if (parse_debug)
				fprintf(stderr, "file new mode defined\n");
		}
|	OWNER_STRING DEFAULT_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_OWNER;
			$$->value = $3;
			$$->level = strdup(DEFAULT_DECLARE_STRING);
			$$->next = $5;
			if (parse_debug)
				fprintf(stderr, "file old owner defined\n");
		}
|	OWNER_STRING QUOTED_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_OWNER;
			$$->value = $3;
			$$->level = $2;
			$$->next = $5;
			if (parse_debug)
				fprintf(stderr, "file new ownere defined\n");
		}
|	GROUP_STRING DEFAULT_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_GROUP;
			$$->value = $3;
			$$->level = strdup(DEFAULT_DECLARE_STRING);
			$$->next = $5;
			if (parse_debug)
				fprintf(stderr, "file old group defined\n");
		}
|	GROUP_STRING QUOTED_STRING QUOTED_STRING ';' filebody
		{
			$$ = (struct filebodystr *)
				malloc(sizeof(struct filebodystr));
			$$->type = FILE_GROUP;
			$$->value = $3;
			$$->level = $2;
			$$->next = $5;
			if (parse_debug)
				fprintf(stderr, "file new group defined\n");
		}
;

%%

int policywrap(void) {
	return(1);
}
