/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: libktoken.h,v 1.3 1998/06/26 13:17:36 robert Exp $
 */

/* 
 * Userland library wrappers for syscalls 
 */

#ifndef _LIBKTOKEN_H
#define _LIBKTOKEN_H

/* library support for kernel tokens */

pagid_t t_newpag();
pagid_t t_getpag();

int t_readtoken(tokenid_t tokenid, struct utokenstr *p_token);
int t_modifytoken(tokenid_t tokenid, int whichfield, struct utokenstr *p_token);
tokenid_t t_createtoken(struct utokenstr *p_token);
tokenid_t t_reflecttoken(tokenid_t utokenid);
int t_deletetoken(tokenid_t tokenid);
tokenid_t t_findtoken(tokenid_t mintokenid, u_int32_t whichfields,
                        struct utokenstr *p_token);
int t_setdebug(int debuglevel);

/* extra routines */

void t_tokenprettyprint(struct utokenstr *p_token);


#endif
