/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken_structs.h,v 1.4 1998/06/26 13:17:32 robert Exp $
 */

/*
 * Structures common to both the userland and kernel code (tokens, etc)
 */

#ifndef _KTOKEN_STRUCTS_H
#define _KTOKEN_STRUCTS_H

struct utokenstr
{
    tokenid_t tokenid;                    /* unique across system */
    char name[T_STRINGLEN_MAX];           /* name of token -- \0-terminated */
    char realm[T_STRINGLEN_MAX];          /* realm of token -- \0-terminated */
    u_int32_t rights;                     /* bitmask of rights */
    int major, minor, minorminor;         /* type values */
    u_int16_t publiclen, privatelen;      /* lenth of token data fields */
    char publicdat[T_DATALEN_MAX];        /* public data */
    char privatedat[T_DATALEN_MAX];       /* private data */
    time_t expiretime;                    /* seconds since epoch of expiry */
    time_t createtime;                    /* time token created */
    int creator;                          /* field indicating creator */
};

#endif
