/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken_syscall.h,v 1.3 1998/06/26 13:17:32 robert Exp $
 */

/*
 * Syscall arguments 
 */

#ifndef _KTOKEN_SYSCALL_H
#define _KTOKEN_SYSCALL_H

struct t_syscall_args {
	int whichfunction;	// which one of the following functions
	void *args;		// pointer to arguements
};

/*
 * Token control calls
 */

#define TOKEN_CONTROL_MIN	1
#define TOKEN_CONTROL_MAX	1

#define TOKEN_SYSCALL_DEBUG	1
struct t_debug_args {
	int	debug;	// whether or not to print debugging
};

/*
 * PAG-related calls
 */

#define TOKEN_PAGCALL_MIN	16
#define TOKEN_PAGCALL_MAX	17

#define TOKEN_SYSCALL_NEWPAG		16
struct t_newpag_args {
	pagid_t *p_pagid;		// New pagid
};

#define TOKEN_SYSCALL_GETPAG		17
struct t_getpag_args {
	pagid_t *p_pagid;		// where to put the pagid
};

/*
 * TOKEN-related calls
 */

#define TOKEN_TOKCALL_MIN	32
#define TOKEN_TOKCALL_MAX	37

#define TOKEN_SYSCALL_READTOKEN		32
struct t_readtoken_args {
	tokenid_t tokenid;		// which token (64-bit)
	struct utokenstr *p_token;	// where to put token
};

#define TOKEN_SYSCALL_MODIFYTOKEN	33
struct t_modifytoken_args {
	tokenid_t tokenid;		// which token (64-bit)
	int whichfields;		// which field to copy
	struct utokenstr *p_token;	// where to get new field from
};

#define TOKEN_SYSCALL_CREATETOKEN	34
struct t_createtoken_args {
	tokenid_t *p_tokenid;		// where to put tokenid when done
	struct utokenstr *p_token;	// where to get the token from
};

#define TOKEN_SYSCALL_REFLECTTOKEN	35
struct t_reflecttoken_args {
	tokenid_t tokenid1;		// which token to reflect
	tokenid_t *p_tokenid2;		// where to put new tokenid
};

#define TOKEN_SYSCALL_DELETETOKEN	36
struct t_deletetoken_args {
	tokenid_t tokenid;		// which token to delete
};

#define TOKEN_SYSCALL_FINDTOKEN		37
struct t_findtoken_args {
	tokenid_t	mintokenid;	// find a tokenid >= this
	u_int32_t	whichfields;	// match which fields
	tokenid_t	*p_tokenid;	// token found
	struct utokenstr *p_token;	// the fields to match against
};

#endif
