/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken_kstructs.h,v 1.4 1998/06/26 13:17:34 robert Exp $
 */

/*
 * ktoken structures used only in the kernel
 */

#ifndef _KTOKEN_KSTRUCTS_H
#define _KTOKEN_KSTRUCTS_H

/*
 * global list management
 */
#define TOKHASH(tokenid)        (&tokhashtbl[(tokenid) & tokhash])

/*
 * kernel token structure
 */
struct ktokenstr {
    /**** this must be first in the struct to facility memcpy ****/
    struct utokenstr utoken;   /* user-visible portions of token */
    /*************************************************************/
    
    /* kernel fields */
    int refcount;                   /* number of pags referring to it */
    LIST_ENTRY(ktokenstr) t_hash;   /* global token hash chain */
};

/*
 * structure to hold a reference to a token in a PAG
 */
struct ktokenrefstr {
    int refcount;                          /* number of pointers in use */
    struct ktokenstr *token;               /* ptr to the real token */
    LIST_ENTRY(ktokenrefstr) t_list;       /* list of tokenrefs in pag */
};

/*
 * structure to hold a pag
 */
struct pagstr {
    pagid_t pagid;                        /* unique pag identifier */
    u_int32_t refcount;                   /* number of processes
					     referring to pag */
    
    /* resource limits associates with the pag */
    u_int32_t numtokens;                  /* number of tokens in the pag */
    u_int32_t maxtokens;                  /* max tokens that the pag
                                             can have */
    
    /* list of tokenrefs */
    LIST_HEAD(,ktokenrefstr) t_list;	/* list of tokenrefs */
};

#endif
