/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktoken_support.h,v 1.4 1998/06/26 13:17:34 robert Exp $
 */

/* 
 * function prototypes, macros for support routines
 */

#ifndef _KTOKEN_SUPPORT_H
#define _KTOKEN_SUPPORT_H

#define KTDEBUG(level, line...) if (ktdebug>level) \
                                   printf(## line)

#define KTOKEN_PERMITS(t, r) ((t)->utoken.rights & (r))


void t_internal_init(void);
void t_internal_shutdown(void);

void t_internal_decref_tokenstr(struct ktokenstr *p_token);
void t_internal_decref_tokenrefstr(struct ktokenrefstr *p_tokenref);
void t_internal_removetokenlist(struct pagstr *p_pagstr);
void t_internal_decref_pagstr(struct pagstr *p_pagstr);

void t_internal_return_pagstr(struct pagstr *p_pag);
void t_internal_return_tokenrefstr(struct ktokenrefstr *p_tokenref);

pagid_t t_internal_nextpagid(void);
void t_internal_newpag(struct pagstr **pp_pag,
		       int flags);
void t_internal_inheritpag(struct pagstr *old,
			   struct pagstr *new);
void t_internal_remove_proc_pag(struct proc *p,
				struct pagstr *old);
void t_internal_add_proc_pag(struct proc *p,
			     struct pagstr *new);
void t_internal_find_pag_by_proc(struct pagstr **pag,
				 struct proc *p);
void t_internal_find_token_by_tokenid(tokenid_t tokenid,
				      struct ktokenstr **token);
void t_internal_pag_get_tokenref(struct pagstr *p_pag,
				 struct ktokenstr *p_token,
				 struct ktokenrefstr **pp_tokenref);
void t_internal_copy_token_fields(struct utokenstr *dest,
				  struct utokenstr *source,
				  u_int fields);
int t_internal_read_token(struct pagstr *p_pag,
			  struct ktokenstr *p_token,
			  struct utokenstr *outtoken);
int t_internal_token_matches(u_int whichfields,
			     struct utokenstr *p_token1,
			     struct utokenstr *p_token2);
void t_internal_search_token(struct pagstr *p_pag,
			     tokenid_t mintokenid,
			     u_int whichfields,
			     struct utokenstr *model,
			     struct ktokenstr **p_token);
int t_internal_modify_token(int origin,
			    struct pagstr *pag,
			    struct ktokenstr *token,
			    struct utokenstr *model,
			    int fields);
int t_internal_add_token_to_pag(struct ktokenstr *p_token,
				struct pagstr *p_pag);
tokenid_t t_internal_nexttokenid(void);
int t_internal_may_create_token_type(int origin,
				     struct pagstr *p_pag,
				     int major,
				     int minor,
				     int minorminor);
int t_internal_create_token(int origin,
			    struct pagstr *p_pag,
			    struct utokenstr *model,
			    struct ktokenstr **outtoken);
int t_internal_reflect_token(struct pagstr *p_pag,
			     struct ktokenstr *p_token,
			     struct ktokenstr **outtoken);
int t_internal_remove_token_from_pag(struct pagstr *p_pag,
				     struct ktokenstr *p_token);
int t_internal_delete_token(int origin,
			    struct pagstr *p_pag,
			    struct ktokenstr *p_token);

#endif
