/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: procmap.c,v 1.3 1998/06/26 13:17:34 robert Exp $
 */

/* 
 * map proc's to pag's via a simple hash table
 * this is a fixed size, non-chaning hash table, so may get full
 * really just a hack until there is an appropriate proc structure entry
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/exec.h>
#include <sys/sysent.h>
#include <sys/lkm.h>
#include <sys/malloc.h>
#include <sys/errno.h>
#include <sys/proc.h>
#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "../common/ktoken_syscall.h"
#include "ktoken_kconst.h"
#include "ktoken_kstructs.h"
#include "ktoken.h"
#include "ktoken_support.h"
#include "procmap.h"

/* array */
#define PAGMAP_SIZE PROC_TABLE_SIZE
static struct pagstr *pag_mapping[PAGMAP_SIZE];
#define PROCHASH(i) (i->p_pid % PAGMAP_SIZE)

/* initialize the hash table */
void pagmap_init(void) {
    int i;
    for (i=0; i<PAGMAP_SIZE; i++) {
	pag_mapping[i] = 0;
    }
}

/* given a pid, return a pag */
struct pagstr *pagmap_get_map(struct proc *p) {
    return pag_mapping[PROCHASH(p)];
}

/* given a pid, pag, add a mapping */
void pagmap_add_map(struct proc *p, struct pagstr *pag) {
    if (!(pagmap_get_map(p))) {
	pag_mapping[PROCHASH(p)] = pag;
    } else {
	KTDEBUG(0, "ktoken.pagmap_add_map(): pid hash collision\n");
    }
}

/* given a pid, pag, remove the mapping */
void pagmap_remove_map(struct proc *p) {
    if (!(pagmap_get_map(p))) {
	KTDEBUG(0, "ktoken.pagmap_remove_map(): pid not assigned\n");
    } else {
	pag_mapping[PROCHASH(p)] = 0;
    }
}
