/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: tokcontrol.c,v 1.1 1998/07/06 00:18:42 robert Exp $
 */
#include <sys/types.h>
#include <sys/time.h>
#include <machine/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

void helpargs(void) {
    printf("tokcontrol [command] [commandargs]\n");
    printf("Commands:\n");
    printf("  debug [debuglevel]\n");
    printf("  createtokend\n");
}

void main(int argc, char *argv[])
{
    char *command, **commandargs;
    int numcommandargs, i;

    if (argc < 2) {
	helpargs();
	exit(-1);
    }

    command = argv[1];
    commandargs = &argv[2];
    numcommandargs = argc - 2;

    if (!strcmp(command, "debug")) {
	if (numcommandargs != 1) {
	    helpargs();
	    exit(-1);
	}
	i = t_setdebug(atoi(commandargs[0]));
	if (i) {
	    perror("t_setdebug");
	    exit(-1);
	}
	exit(0);
    } else if (!strcmp(command, "createtokend")) {
	if (numcommandargs != 0) {
	    helpargs();
	    exit(-1);
	}
	i = t_settokend();
	if (i) {
	    perror("t_settokend");
	    exit(-1);
	}
	exit(0);
    } else {
	helpargs();
	exit(-1);
    }
}
