/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ktokenloader.c,v 1.6 1998/07/21 23:22:56 robert Exp $
 */

/*
 * ktoken routines to run when the module is loaded, unloaded 
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/exec.h>
#include <sys/sysent.h>
#include <sys/lkm.h>
#include <sys/malloc.h>
#include <sys/queue.h>

#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "../common/ktoken_syscall.h"
#include "ktoken_kstructs.h"
#include "ktoken.h"
#include "ktoken_support.h"

extern int ktoken_syscall __P((struct proc *p, void *uap));
#ifdef KTOKEN_TRANSFER
extern int ktoken_unp_externalize __P((void *control, struct proc *p));
extern int ktoken_unp_internalize __P((void *control, struct proc *p));
extern int ktoken_unp_gc __P((void *control));
#endif

static int	ktoken_event __P((struct lkm_table *lkmtp, int cmd));
extern int	ktoken_mod __P((struct lkm_table *lkmtp, int cmd, int ver));

static struct sysent newent = {
        (sizeof(struct t_syscall_args)/sizeof(int)), /* # args */
	ktoken_syscall	/* function pointer */
};

#ifdef MOD_PRIVATE
MOD_SYSCALL(ktoken_mod, -1, &newent);
#else
MOD_SYSCALL("ktoken_mod", -1, &newent);
#endif

static int
ktoken_event( lkmtp, cmd)
struct lkm_table	*lkmtp;
int			cmd;
{
	printf("ktoken_event(): event %d\n", cmd);
	
	if( cmd == LKM_E_LOAD) {
		printf("ktoken_event(): load\n");
		t_internal_init();
		at_fork(ktoken_at_fork);
		at_exit(ktoken_at_exit);
#ifdef KTOKEN_TRANSFER
		at_unp_internalize(ktoken_unp_internalize);
		at_unp_externalize(ktoken_unp_externalize);
		at_unp_gc(ktoken_unp_gc);
#endif
	}
	else if (cmd == LKM_E_UNLOAD) {
		printf("ktoken_event(): unload\n");
		t_internal_shutdown();
		rm_at_fork(ktoken_at_fork);
		rm_at_exit(ktoken_at_exit);
#ifdef KTOKEN_TRANSFER
		rm_at_unp_internalize(ktoken_unp_internalize);
		rm_at_unp_externalize(ktoken_unp_externalize);
		rm_at_unp_gc(ktoken_unp_gc);
#endif
	}
	else if (cmd = LKM_E_STAT) {
		printf("ktoken_event(): stat\n");
	}
	else {
		printf("ktoken_event(): what?\n");
	}

	return(0);
}

int
ktoken_mod( lkmtp, cmd, ver)
struct lkm_table	*lkmtp;
int			cmd;
int			ver;
{
	MOD_DISPATCH(ktoken_mod, lkmtp, cmd, ver,
	    ktoken_event, ktoken_event, ktoken_event)
}
