/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      $Id: receivetoken.c,v 1.2 1998/07/25 05:34:04 robert Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdio.h>
#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

int main(int argc, char *argv[]) {
    struct sockaddr_un bindaddr, connaddr;
    int listensock, connsock, connaddrlen, i;
    struct msghdr msg;
    struct {
	struct cmsghdr cmsghdr;
	tokenid_t tokenid;
    } cmsg;
    struct iovec vec;
    char b;
    vec.iov_base = &b;
    vec.iov_len = sizeof(b);

    if (argc != 2) {
	fprintf(stderr, "receivetoken [pathtosocket]\n");
	exit(-1);
    }

    listensock = socket(PF_LOCAL, SOCK_STREAM, /* ??? */ 0);
    if (listensock == -1) {
	perror("test1.socket()");
	exit(-1);
    }
    printf("test1.socket(): returned %d\n", listensock);

    /* unlink to be safe */
    i = unlink(argv[1]);
    if (!i) {
	printf("test1.bind(): removed old socket\n");
    }

    bindaddr.sun_family = AF_LOCAL;
    bindaddr.sun_len = sizeof(struct sockaddr_un);
    strcpy(bindaddr.sun_path, argv[1]);

    i = bind(listensock, (struct sockaddr *) &bindaddr,
	     sizeof(struct sockaddr_un));
    if (i) {
	perror("test1.bind()");
	exit(-1);
    }

    i = listen(listensock, -1); /* default to somaxconn backlog */
    if (i) {
	perror("test1.listen()");
	exit(-1);
    }

    while (1) {
	connsock = accept(listensock, (struct sockaddr *) &connaddr,
			  &connaddrlen);
	if (connsock == -1) {
	    perror("test1.accept()");
	    exit(-1);
	}
	printf("test1.accept(): returned %d\n", connsock);

	/* now attempt to receive */
	
	msg.msg_name = 0;
	msg.msg_namelen = 0;
	msg.msg_iov = &vec;
	msg.msg_iovlen = 1;
	msg.msg_control = (caddr_t) &cmsg;
	msg.msg_controllen = sizeof(cmsg);
	msg.msg_flags = 0;

	i = recvmsg(connsock, &msg, 0);

	if (i == -1) {
	    perror("test1.recvmsg()\n");
	    exit(-1);
	}

	printf("test1.recvmsg(): received %d, msg.msg_controllen = %d\n", i,
	       msg.msg_controllen);

	printf("Tokenid: %lu\n", cmsg.tokenid);

	i = close(connsock);
	if (i) {
	    perror("test1.close()");
	    exit(-1);
	}
    }
    return(0);
}
