/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: createuidtoken.c,v 1.2 1998/07/06 00:18:42 robert Exp $
 */
#include <sys/types.h>
#include <sys/time.h>
#include <machine/types.h>
#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

int main(int argc, char *argv[])
{
/*************
 * Test Code *
 *************/

	struct utokenstr token1;
	tokenid_t tokenid;
	int uid;

	if (argc != 2) {
		printf("createuidtoken [uid]\n");
		exit(-1);
	}

	uid = atoi(argv[1]);

	printf("createuidtoken: preparing to generate a token for %d\n", uid );
	memset(&token1, '\0', sizeof(struct utokenstr));
	token1.major = TOKEN_MAJ_LOCALPRIV;
	token1.minor = TOKEN_LPRIV_UID;
	token1.minorminor = uid;
	token1.rights = T_R_INHERIT | T_R_DELETE;
	strcpy(token1.name, "setuid1");
	strcpy(token1.realm, "localpriv");
	token1.publiclen = 0;
	token1.privatelen = 0;
	token1.createtime = time(0);
	tokenid = t_createtoken(&token1);
	if (!tokenid) {
		perror("createtoken");
		exit(-1);
	}
	printf("createtoken: received tokenid %lu\n", tokenid);

/*****************
 * End Test Code *
 *****************/
	return(0);
}
