/*-
 * Copyright (c) 1998 Robert N. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name Robert N. Watson may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: sendtoken.c,v 1.1 1998/07/21 23:22:57 robert Exp $
 */
/*
 * Program to transfer a token to an arbitrary unix domain socket 
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <sys/un.h>
#include <machine/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../common/ktoken_const.h"
#include "../common/ktoken_types.h"
#include "../common/ktoken_structs.h"
#include "libktoken.h"

int main(int argc, char *argv[]) {
	struct sockaddr_un saddr;
	struct msghdr msg;
	struct {
		struct cmsghdr cmsghdr;
		tokenid_t tokenid;
	} cmsg;
	struct iovec vec;
	char b;
	int sock, i;

	vec.iov_base = &b;
	vec.iov_len = sizeof(b);

	if (argc != 3) {
		fprintf(stderr, "sendtoken [tokenid] [pathtosocket]\n");
		exit(-1);
	}
	if (strlen(argv[2]) > 103) {
		fprintf(stderr, "sendtoken: socket name too long\n");
	}
	
	cmsg.tokenid = atoi(argv[1]);
	sock = socket(PF_LOCAL, SOCK_STREAM, 0);
	if (sock == -1) {
		perror("sendtoken.socket()");
		exit(-1);
	}
	
	saddr.sun_family = AF_LOCAL;
	saddr.sun_len = sizeof(struct sockaddr_un);
	strcpy(saddr.sun_path, argv[2]);
	i = connect(sock, (struct sockaddr *) &saddr, sizeof(struct sockaddr_un));
	if (i) {
		perror("sendtoken.connect()");
		exit(-1);
	}

	/* send the token */
	msg.msg_name = 0;
	msg.msg_namelen = 0;
	msg.msg_iov = &vec;
	msg.msg_iovlen = 1;
	msg.msg_control = (caddr_t) &cmsg;
	msg.msg_controllen = sizeof(cmsg);
	msg.msg_flags = 0;

	cmsg.cmsghdr.cmsg_len = sizeof(cmsg);
	cmsg.cmsghdr.cmsg_level = SOL_SOCKET;
	cmsg.cmsghdr.cmsg_type = SCM_KTOKENS;
	/* tokenid already set above from atoi */

	i = sendmsg(sock, &msg, 0);
	if (i == -1) {
		perror("sendtoken.sendmsg()");
		exit(-1);
	}

	printf("sendtoken(): success\n");

	return(0);
}


