/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "nfs_cntl.h"
#include <stdio.h>
#include <stdlib.h> /* getenv, exit */
#include <rpc/rpc_com.h>
#include <fcntl.h> /* open */
#include <unistd.h> /* fork / setsid */
#include <sys/types.h>
#include <memory.h>
#include <sys/resource.h> /* rlimit */
#include <syslog.h>

#include <sys/select.h>
#include <sys/socket.h>
#include <stdio.h>
#include <errno.h>

static void
nfscntl_prog_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		char *execcommand_1_arg;
		addr add_listener_1_arg;
		addr remove_listener_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULL:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) null_1;
		break;

	case EXECCOMMAND:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_reply;
		local = (char *(*)()) execcommand_1;
		break;

	case ADD_LISTENER:
		xdr_argument = xdr_addr;
		xdr_result = xdr_reply;
		local = (char *(*)()) add_listener_1;
		break;

	case REMOVE_LISTENER:
		xdr_argument = xdr_addr;
		xdr_result = xdr_reply;
		local = (char *(*)()) remove_listener_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, (char *)&argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (char *)&argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}

#define RPC_SVC_FG

void run(void);

pid_t ppid;
int sock;

int
main()
{
	int maxrec = RPC_MAXDATASIZE;
	pid_t pid;

#ifndef RPC_SVC_FG
		int size;
		struct rlimit rl;
		pid = fork();
		if (pid < 0) {
			perror("cannot fork");
			exit(1);
		}
		if (pid)
			exit(0);
		rl.rlim_max = 0;
		getrlimit(RLIMIT_NOFILE, &rl);
		if ((size = rl.rlim_max) == 0)
			exit(1);
		for (i = 0; i < size; i++)
			(void) close(i);
		i = open("/dev/console", 2);
		(void) dup2(i, 1);
		(void) dup2(i, 2);
		setsid();
		openlog("nfs_cntl", LOG_PID, LOG_DAEMON);
#endif
	ppid = getppid();
	
	if ( (sock = socket (AF_INET, SOCK_DGRAM, 0)) == -1) {
	    syslog(LOG_ERR, "   .");
	    exit ( 1);
	}
	rpc_control(RPC_SVC_CONNMAXREC_SET, &maxrec);
	if (!svc_create(nfscntl_prog_1, NFSCNTL_PROG, NFSCNTL_VER, "netpath")) {
		fprintf(stderr, "unable to create (NFSCNTL_PROG, NFSCNTL_VER) for netpath.");
		exit(1);
	}

	syslog (LOG_DEBUG, " ");
	run();
	fprintf(stderr, "run returned");
	exit(1);
	/* NOTREACHED */
}


void getdata(void);

void run(void) {
	fd_set readfds;
	struct timeval timeout;

	timeout.tv_sec = 30;
	timeout.tv_usec = 0;

	for (;;) {
		readfds = svc_fdset;
		FD_SET (0, &readfds);
		switch (select(svc_maxfd+1, &readfds, NULL, NULL, &timeout)) {
		case -1:
			FD_ZERO(&readfds);
			if (errno == EINTR) {
				continue;
			}
			syslog(LOG_ERR, "run: select failed");
			return;
		case 0:
			continue;
		default:
			if (FD_ISSET(0, &readfds))
			    getdata();
			else
			    svc_getreqset(&readfds);
		}
	}
}
