/*
*         NFS.
*        .
* 
* :  
*          .
* $Id: nfs_control.lex,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $
*/

%{
#define COMMAND_ERROR	-1
#define COMMAND_ADD	1
#define COMMAND_DEL	2
#define COMMAND_RECOVER	3
#define COMMAND_RETRY	4
#define COMMAND_UPDATE	5
#define COMMAND_STATE	6
#define COMMAND_LIST	7
#define COMMAND_SET	8
#define COMMAND_MASTER  9
#define COMMAND_DELM	10

#define COMMLEN( str)	( sizeof( str) - 1)
#define COMMLEN_RETRY	COMMLEN("retry")
#define COMMLEN_TIMEOUT	COMMLEN("timeout")
#define COMMLEN_SET	COMMLEN("set")
#define COMMLEN_MASTER	COMMLEN("master")

#define OPTIONS_STR	"csfrae"
#define OPTION_CLIENT	(1 << 0)
#define OPTION_SOFT	(1 << 1)
#define OPTION_FORCE	(1 << 2)
#define OPTION_REQUEST	(1 << 3)
#define OPTION_AUTO	(1 << 4)
#define OPTION_EXTEND	(1 << 5)
#define OPTIONS( command, state, test)	\
	yycommand = command; yystate = state; \
	yyoptions_test = test; yyoptions_mask = 0; \
	BEGIN(options)

#define ARGS( arg, value, min, max)	\
	arg = value; arg = ( arg <= min) ? min : (( arg > max) ? max : arg)
#define ARGS_RETRYMIN	-1
#define ARGS_RETRYMAX	10
#define ARGS_TIMEOUTMIN	1
#define ARGS_TIMEOUTMAX	10
#define ARGS_UPDATEMIN	1
#define ARGS_UPDATEMAX	64
#define ARGS_UPDATERMIN	0
#define ARGS_UPDATERMAX	8
#define ARGS_SET	'$'
%}

NUM	([[:digit:]])+
ADDRTAG	[[:alnum:]\243\263\300-\377\_\-]
ADDR	({ADDRTAG}+)("."({ADDRTAG}+)){0,4}(:{NUM})?
VAR	$[[:digit:]]
SP	[ \t]+
END	[;\n]
NOEND	[^;\n]+
NOSPEND	[^ \t;\n]+
%x end options update address
%option noyywrap always-interactive
%%
	int yycommand = 0;
	int yystate = INITIAL;
	u_long yyoptions_test, yyoptions_mask;
	int yynumber;
	static char yyvars[10][32] = { "", "", "", "", "", "", "", "", "", ""};

<*>{END}	{
	  switch( yycommand){
	    case COMMAND_STATE:
		if(( yyoptions_mask & OPTION_CLIENT) || (yyoptions_mask & OPTION_EXTEND)){
		  if( yyoptions_mask & OPTION_FORCE)
		    nfs_externlockflag = FALSE;
		  if( nfs_externlockname[0] != 0)
		    msg( 1, nfs_externlockflag ? 14 : 15, nfs_externlockname);
		  else
		    msg( 1, 28);
		}
		if(!( yyoptions_mask & OPTION_CLIENT) || (yyoptions_mask & OPTION_EXTEND)){
		  if( yyoptions_mask & OPTION_FORCE){
		    if( nfs_recoverflag){
		      msg( 1, 6, clnt_recover->name);
		      clnt_recoverstop();
		    }
		    else
		      msg( 2, 20);
		  }
		  else
		    if( nfs_recoverflag){
		      register int i;

		      for( i = 0; i < clnts_num; i++)
		        msg( 1, ( &clnts[i] == clnt_recover) ? 19 : 9, clnts[i].retry, clnts[i].name);
		    }
		    else
		      msg( 1, 27);
		}
		if( !(yyoptions_mask & OPTION_EXTEND)){
		  yystate = INITIAL;
		  break;
		}
	    case COMMAND_LIST:
		{
                  struct sockaddr_in local_addr;
		  char name[32];
		  register int i;

		  if(( yyoptions_mask & OPTION_CLIENT) || (yyoptions_mask & OPTION_EXTEND)){
		    for( i = 1; i < client_num; i++){
		      sprintf( name, "%s:%hu", inet_ntoa( client[i].addr.sin_addr.s_addr), ntohs( client[i].addr.sin_port));
		      msg( 1, 16, name);
		    }
#ifdef NFS_CLNTUDP
		    if((clnt_sock != RPC_ANYSOCK) && !get_myaddress(&local_addr)){
                      if(clnt_port == 0){
                        struct sockaddr_in addr;
                        int addrlen = sizeof(addr);
         
                        if(!getsockname(clnt_sock, (struct sockaddr *) &addr, &addrlen))
                          clnt_port = ntohs(addr.sin_port);
                      }
		      sprintf( name, "%s:%hu", inet_ntoa(local_addr.sin_addr), clnt_port);
		      msg( 1, 26, name);
                    }
#endif /* NFS_CLNTUDP */
		  }
		  if(!( yyoptions_mask & OPTION_CLIENT) || ( yyoptions_mask & OPTION_EXTEND)){
		    for( i = 0; i < clnts_num; i++)
		      msg( 1, ( &clnts[i] == clnt_recover) ? 19 : 9, clnts[i].retry, clnts[i].name);
		    if(!get_myaddress(&local_addr)){
		      sprintf( name, "%s:%hu", inet_ntoa(local_addr.sin_addr), extern_transp->xp_port);
		      msg( 1, 20, name);
                    }
		  }
		}
		yystate = INITIAL;
		break;
	    case COMMAND_UPDATE:
		if( yyoptions_mask & OPTION_FORCE){
		  nfs_fhrefresh();
		  nfs_fhupdateflag = FALSE;
		  msg( 1, 24);
		}
		if( yyoptions_mask & OPTION_AUTO){
		  nfs_fhupdateflag = TRUE;
		  msg( 1, 25);
		}
		if( yyoptions_mask & OPTION_REQUEST)
		  msg( 1, 23, update_countreq);
		else
		  msg( 1, 22, update_count);		
		yystate = INITIAL;
		break;
	  }
	  if( yystate != INITIAL){
	    msg( 2, 10);
	  }
	  yycommand = 0;
	  yystate = INITIAL;
	  BEGIN(INITIAL);
	}
<*>{SP}

add	{ msg( 1, 10, yytext); OPTIONS( COMMAND_ADD, address, OPTION_CLIENT); }
del	{ msg( 1, 10, yytext); OPTIONS( COMMAND_DEL, address, OPTION_CLIENT); }
recover	{ msg( 1, 10, yytext); OPTIONS( COMMAND_RECOVER, address, OPTION_SOFT | OPTION_FORCE); }
retry({SP})?"-"?{NUM}({SP})?	{ msg( 1, 10, yytext); yycommand = COMMAND_RETRY; yystate = address; BEGIN(address);
	  ARGS( yynumber, atoi( yytext + COMMLEN_RETRY), ARGS_RETRYMIN, ARGS_RETRYMAX);
	}
timeout({SP}{NUM})?	{ msg( 1, 10, yytext); BEGIN(end);
	  if( strlen( yytext) != COMMLEN_TIMEOUT){
	    ARGS( yynumber, atoi( yytext + COMMLEN_TIMEOUT), ARGS_TIMEOUTMIN, ARGS_TIMEOUTMAX);
	    TIMEOUT.tv_sec = yynumber;
	  }
	  msg( 1, 17, TIMEOUT.tv_sec);
	}
update	{ msg( 1, 10, yytext); OPTIONS( COMMAND_UPDATE, update, OPTION_REQUEST | OPTION_FORCE | OPTION_AUTO); }
state	{ msg( 1, 10, yytext); OPTIONS( COMMAND_STATE, end, OPTION_CLIENT | OPTION_FORCE | OPTION_EXTEND); }
list		{ msg( 1, 10, yytext); OPTIONS( COMMAND_LIST, end, OPTION_CLIENT); }
help|"\?"	{ msg( 1, 10, yytext); msg( 3, 1); BEGIN(end); }
quit		{ msg( 1, 10, yytext); quit(0); }
set({SP}[[:digit:]])?	{ msg( 1, 10, yytext); 
	  if( strlen( yytext) != COMMLEN_SET){
	    ARGS( yynumber, atoi( yytext + COMMLEN_SET), 0, 9);
	    yycommand = COMMAND_SET; yystate = address; BEGIN(address);
	  }
	  else {
	    register i;

	    for( i = 0; i < 10; i++)
	      if( yyvars[i][0] != 0)
	        msg( 1, 21, i, yyvars[i]);
            BEGIN(end);
	  }
	}
master({SP})?	{ msg( 1, 10, yytext); 
	  if( strlen( yytext) != COMMLEN_MASTER){
  	    yycommand = COMMAND_MASTER; yystate = address; BEGIN(address);
	  }
          else {
            if (master_transp)
              msg (1, 30,
                inet_ntoa(((struct sockaddr_in*)master_transp->xp_ltaddr.buf)->sin_addr.s_addr),
                ntohs(((struct sockaddr_in*)master_transp->xp_ltaddr.buf)->sin_port));
            BEGIN(end);
          }
	}
delm	{ msg( 1, 10, yytext);
	  if( master_transp != NULL){
	    svc_destroy(master_transp);
	    svc_unregister(NFS_PROGRAM, NFS_VERSION);
	    (void) pmap_unset(NFS_PROGRAM, NFS_VERSION);
            master_transp = NULL;
            msg( 1, 31);
	  }
	}
end|"."		return;
{NOSPEND}	{ msg( 2, 1, yytext); yycommand = COMMAND_ERROR; BEGIN(end); }

<end>{NOEND}	{ if( yycommand != COMMAND_ERROR) msg( 2, 10); }

<options>"-"([[:alnum:]])+	{
	  char yyoptions_str[] = OPTIONS_STR;
          register int i = 0;
          
          while( yytext[++i] != 0){
            char *fp = strchr( yyoptions_str, yytext[i]);
            
            if( fp != NULL){
              u_long mask = ((u_long)1) << ( fp - yyoptions_str);

              if( yyoptions_test & mask){
                yyoptions_mask |= mask;
                continue;
              }
            }
	    msg( 2, 17, yytext[i]);
          }
	}
<options>.	{ yyless(0); BEGIN(yystate); yystate = INITIAL; }

<update>{NUM}	{
	  if( yyoptions_mask & OPTION_REQUEST){
	    ARGS( update_countreq, atoi( yytext), ARGS_UPDATERMIN, ARGS_UPDATERMAX);
	  }
	  else {
	    ARGS( update_count, atoi( yytext), ARGS_UPDATEMIN, ARGS_UPDATEMAX);
	  }
	  BEGIN(end);
	}
<update>.	{ yyless(0); BEGIN(end); }

<address>{ADDR}|{VAR}	{
	  char *str = yytext;
	  register int i;

	  if( yytext[0] == ARGS_SET){
	    ARGS( i, atoi( yytext + 1), 0, 9);
	    str = yyvars[i];
	    if( str[0] == 0){
	      msg( 2, 18, i);
	      str = NULL;
	    }
	  }
          if( str != NULL)
            switch(yycommand){
	      case COMMAND_ADD:
		if( yyoptions_mask & OPTION_CLIENT){
		  struct sockaddr_in inetaddr;
		  char *name = addr_parse( str, &inetaddr);

		  if( name != NULL){
		    if( client_add( &inetaddr, 0, FALSE) != -1)
		      msg( 1, 13, name);
		    else
		      msg( 2, 16, name);
		  }
		}
		else
		  clnt_add( str);
		break;
	    case COMMAND_DEL:
		if( yyoptions_mask & OPTION_CLIENT){
		  struct sockaddr_in inetaddr;
		  char *name = addr_parse( str, &inetaddr);

		  if( name != NULL){
		    if( client_del( &inetaddr) != -1)
		      msg( 1, 18, name);
		    else
		      msg( 2, 16, name);
		  }
		}
		else {
		  i = clnt_find( str);
		  if(( i >= 0) && ( i < clnts_num))
		    clnt_del( i);
		}
		break;
	    case COMMAND_RECOVER:
		i = clnt_find( str);

		if(( i >= 0) && ( i < clnts_num)){
		  msg( 1, 3, clnts[i].name);
		  if( yyoptions_mask & OPTION_SOFT){
		    msg( 1, 4);
		    nfs_recoverhardflag = FALSE;
		  }
		  else
		    nfs_recoverhardflag = TRUE;
		  if( nfs_externlockflag && ( yyoptions_mask & OPTION_FORCE)){
		    msg( 1, 5);
		    nfs_externlockflag = FALSE;
		  }
		  if( clnt_recoverstart( i)){
		    if( clnt_recover != NULL){
		      msg( 2, 21, clnt_recover->name);
		      msg( 1, 6, clnt_recover->name);
		    }
	  	    clnt_recoverstop();
		  }
		}
		BEGIN(end);
		break;
	    case COMMAND_RETRY:
		i = clnt_find( str);
	
		if(( i >= 0) && ( i < clnts_num)){
		  msg( 1, 8, yynumber, clnts[i].name);
		  clnts[i].retry = yynumber;
		}
		yystate = INITIAL;
		break;
	    case COMMAND_SET:
		{
		  char *name = addr_parse( str, NULL);
		  
		  if( name != NULL){
		    strcpy( yyvars[yynumber], name);
		    msg( 1, 21, yynumber, yyvars[yynumber]);
		  }
		}
		yystate = INITIAL;
		BEGIN(end);
		break;
	    case COMMAND_MASTER:
		{
		  struct sockaddr_in maddr;
                  static SVCXPRT *tmp_transp = NULL;
		  char *name = addr_parse( str, &maddr);

		  if( name != NULL){
	            int sock;
		   
		    if (maddr.sin_port == 0)
		      maddr.sin_port = htons (MASTER_PORT);
		      
	            if ((sock = socket (PF_INET, SOCK_DGRAM, 0)) == -1) {
	              msg( 2, 13, name);
	              return;
	            }
	            if (bind(sock, (const struct sockaddr*)&maddr,
 	              maddr.sin_len) == -1) {
	              msg( 2, 13, name);
	              return;
	            }
		    
                    tmp_transp = svcudp_bufcreate(sock, NFS_MAXPACKET, NFS_MAXPACKET);

	            if (tmp_transp == NULL) {
	              msg( 2, 13, name);
	              return;
	            }
	            if( master_transp != NULL){
	              svc_destroy(master_transp);
	              svc_unregister(NFS_PROGRAM, NFS_VERSION);
	              (void) pmap_unset(NFS_PROGRAM, NFS_VERSION);
	            }

		    master_transp = tmp_transp;
	            if (!svc_register(master_transp, NFS_PROGRAM, NFS_VERSION, nfs_program_2, IPPROTO_UDP)) {
                      fprintf( stderr, ":   \n");
	              exit ( 1);
	            }
		    nfs_fhrefresh();
		    msg (1, 29, name);
		  }
		}
		yystate = INITIAL;
		BEGIN(end);
		break;
	    default:
		return;
	  }
	}
<address>.

%%
