/*
*         NFS.
*        NFS .
*       rpcgen.
* 
* :  
*          .
* $Id: nfs_prot_clnt.c,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $
*/

#include "nfs_prot.h"
#include "nfs_fh.h"
#ifndef lint
/*static char sccsid[] = "from: @(#)nfs_prot.x 1.2 87/10/12 Copyr 1987 Sun Micro";*/
/*static char sccsid[] = "from: @(#)nfs_prot.x	2.1 88/08/01 4.0 RPCSRC";*/
static char rcsid[] = "$Id: nfs_prot_clnt.c,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $";
#endif /* not lint */

/* Default timeout can be changed using clnt_control() */
extern struct timeval TIMEOUT;

#include <stdio.h>

#define NFS_VIRTUAL2FH( savefh, fh)	\
	if( nfs_virtual2fh( savefh, fh) == -1){	\
	  *((nfsstat *) clnt_res) = NFSERR_STALE; \
	  return clnt_res; \
	}

void *
nfsproc_null_2(argp, null, clnt)
	void *argp;
	void *null;
	CLIENT *clnt;
{
	static char clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NFSPROC_NULL,
		(xdrproc_t) xdr_void, (caddr_t) argp,
		(xdrproc_t) xdr_void, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return ((void *)&clnt_res);
}

attrstat *
nfsproc_getattr_2(argp, clnt_res, clnt)
	nfs_fh *argp;
	attrstat *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, argp);
	if (clnt_call(clnt, NFSPROC_GETATTR,
		(xdrproc_t) xdr_nfs_fh, (caddr_t) argp,
		(xdrproc_t) xdr_attrstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

attrstat *
nfsproc_setattr_2(argp, clnt_res, clnt)
	sattrargs *argp;
	attrstat *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->file);
	if (clnt_call(clnt, NFSPROC_SETATTR,
		(xdrproc_t) xdr_sattrargs, (caddr_t) argp,
		(xdrproc_t) xdr_attrstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

void *
nfsproc_root_2(argp, null, clnt)
	void *argp;
	void *null;
	CLIENT *clnt;
{
	static char clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NFSPROC_ROOT,
		(xdrproc_t) xdr_void, (caddr_t) argp,
		(xdrproc_t) xdr_void, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return ((void *)&clnt_res);
}

diropres *
nfsproc_lookup_2(argp, clnt_res, clnt)
	diropargs *argp;
	diropres *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( &savefh, &argp->dir); 
	if (clnt_call(clnt, NFSPROC_LOOKUP,
		(xdrproc_t) xdr_diropargs, (caddr_t) argp,
		(xdrproc_t) xdr_diropres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	if( clnt_res->status == NFS_OK)
	  nfs_fh2virtual( &savefh, &clnt_res->diropres_u.diropres.file, argp->name);
	return clnt_res;
}

readlinkres *
nfsproc_readlink_2(argp, clnt_res, clnt)
	nfs_fh *argp;
	readlinkres *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, argp);
	if (clnt_call(clnt, NFSPROC_READLINK,
		(xdrproc_t) xdr_nfs_fh, (caddr_t) argp,
		(xdrproc_t) xdr_readlinkres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

readres *
nfsproc_read_2(argp, clnt_res, clnt)
	readargs *argp;
	readres *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->file); 
	if (clnt_call(clnt, NFSPROC_READ,
		(xdrproc_t) xdr_readargs, (caddr_t) argp,
		(xdrproc_t) xdr_readres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

void *
nfsproc_writecache_2(argp, null, clnt)
	void *argp;
	void *null;
	CLIENT *clnt;
{
	static char clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NFSPROC_WRITECACHE,
		(xdrproc_t) xdr_void, (caddr_t) argp,
		(xdrproc_t) xdr_void, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return ((void *)&clnt_res);
}

attrstat *
nfsproc_write_2(argp, clnt_res, clnt)
	writeargs *argp;
	attrstat *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->file);
	if (clnt_call(clnt, NFSPROC_WRITE,
		(xdrproc_t) xdr_writeargs, (caddr_t) argp,
		(xdrproc_t) xdr_attrstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

diropres *
nfsproc_create_2(argp, clnt_res, clnt)
	createargs *argp;
	diropres *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( &savefh, &argp->where.dir); 
	if (clnt_call(clnt, NFSPROC_CREATE,
		(xdrproc_t) xdr_createargs, (caddr_t) argp,
		(xdrproc_t) xdr_diropres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	if( clnt_res->status == NFS_OK)
	  nfs_fh2virtual( &savefh, &clnt_res->diropres_u.diropres.file, argp->where.name);
	return clnt_res;
}

nfsstat *
nfsproc_remove_2(argp, clnt_res, clnt)
	diropargs *argp;
	nfsstat *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( &savefh, &argp->dir); 
	if (clnt_call(clnt, NFSPROC_REMOVE,
		(xdrproc_t) xdr_diropargs, (caddr_t) argp,
		(xdrproc_t) xdr_nfsstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	if( clnt_res == NFS_OK)
	  nfs_fhremove( &savefh, argp->name);
	return clnt_res;
}

nfsstat *
nfsproc_rename_2(argp, clnt_res, clnt)
	renameargs *argp;
	nfsstat *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->to.dir); 
	NFS_VIRTUAL2FH( &savefh, &argp->from.dir); 
	if (clnt_call(clnt, NFSPROC_RENAME,
		(xdrproc_t) xdr_renameargs, (caddr_t) argp,
		(xdrproc_t) xdr_nfsstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
        if( *clnt_res == NFS_OK)
	  nfs_fhremove( &savefh, argp->from.name);
	return clnt_res;
}

nfsstat *
nfsproc_link_2(argp, clnt_res, clnt)
	linkargs *argp;
	nfsstat *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->from);
	NFS_VIRTUAL2FH( NULL, &argp->to.dir);
	if (clnt_call(clnt, NFSPROC_LINK,
		(xdrproc_t) xdr_linkargs, (caddr_t) argp,
		(xdrproc_t) xdr_nfsstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

nfsstat *
nfsproc_symlink_2(argp, clnt_res, clnt)
	symlinkargs *argp;
	nfsstat *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->from.dir); 
	if (clnt_call(clnt, NFSPROC_SYMLINK,
		(xdrproc_t) xdr_symlinkargs, (caddr_t) argp,
		(xdrproc_t) xdr_nfsstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

diropres *
nfsproc_mkdir_2(argp, clnt_res, clnt)
	createargs *argp;
	diropres *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( &savefh, &argp->where.dir); 
	if (clnt_call(clnt, NFSPROC_MKDIR,
		(xdrproc_t) xdr_createargs, (caddr_t) argp,
		(xdrproc_t) xdr_diropres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	if( clnt_res->status == NFS_OK)
	  nfs_fh2virtual( &savefh, &clnt_res->diropres_u.diropres.file, argp->where.name);
	return clnt_res;
}

nfsstat *
nfsproc_rmdir_2(argp, clnt_res, clnt)
	diropargs *argp;
	nfsstat *clnt_res;
	CLIENT *clnt;
{
	nfs_fh savefh;

	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( &savefh, &argp->dir); 
	if (clnt_call(clnt, NFSPROC_RMDIR,
		(xdrproc_t) xdr_diropargs, (caddr_t) argp,
		(xdrproc_t) xdr_nfsstat, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	if( clnt_res == NFS_OK)
	  nfs_fhremove( &savefh, argp->name);	
	return clnt_res;
}

readdirres *
nfsproc_readdir_2(argp, clnt_res, clnt)
	readdirargs *argp;
	readdirres *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, &argp->dir); 
	if (clnt_call(clnt, NFSPROC_READDIR,
		(xdrproc_t) xdr_readdirargs, (caddr_t) argp,
		(xdrproc_t) xdr_readdirres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}

statfsres *
nfsproc_statfs_2(argp, clnt_res, clnt)
	nfs_fh *argp;
	statfsres *clnt_res;
	CLIENT *clnt;
{
	memset((char *)clnt_res, 0, sizeof (*clnt_res));
	NFS_VIRTUAL2FH( NULL, argp); 
	if (clnt_call(clnt, NFSPROC_STATFS,
		(xdrproc_t) xdr_nfs_fh, (caddr_t) argp,
		(xdrproc_t) xdr_statfsres, (caddr_t) clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return clnt_res;
}
