/*
*         NFS.
*         NFS .
*       rpcgen.
* 
* :  
* :   <dolgop@mccinet.ru>
*          .
* $Id: nfs_prot_svc.c,v 1.5 2004/03/24 12:47:41 evgeny Exp $
*/

/*#define DEBUG*/
#define VERSION			"0.1b (9  1999)"

#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <nl_types.h>
#include <stdarg.h>

#include "nfs_fh.h"
#include "nfs_recover.h"

#define NFS_CNTLENV		"NFS_PROT_CNTL"
#define NFS_CNTLLENGTH		512
#define NFS_CNTLARGMAX		256
#define NFS_CNTLTIMEOUT		5
#define NFS_CATFILE		"nfs_prot.cat"
#define	NFS_MAXPKTHDR		404
#define NFS_MAXPACKET		(NFS_MAXPKTHDR + NFS_MAXDATA)
#define NFS_LOCKPROCNUM		18
#define NFS_CTRLTIMEOUT		{ 0, 10000 }
#ifndef __linux__
#define NFS_SERVUNIX		"/var/run/nfs"
/*#define NFS_SERVTCP*/
#endif /* !__linux__ */
#define NFS_SERVTIMEOUT		{ 2, 0 }
#define NFS_CLNTMAX		10
#define NFS_CLNTRETRY		3
#define NFS_CLNTIOTIMEOUT	{ 0, 100000 }
#define NFS_CLNTUDP
#ifdef NFS_CLNTUDP
#define NFS_CLNTTIMEOUT		{ 2, 0 }
#define NFS_CLNTUDPRETRYTIMEOUT	{ 1, 0 }
#else /* !NFS_CLNTUDP */
#define NFS_CLNTTIMEOUT		{ 3, 0 }
#endif /* !NFS_CLNTUDP */
#define NFS_UPDATEDEFAULT	8
#define NFS_UPDATEREQDEFAULT	1
/*#define NFS_LOCK*/
#ifdef NFS_LOCK
#define NFS_LOCKNUMBER		10
#define NFS_LOCKTIMEOUT		{ 1, 0 }
#endif /* NFS_LOCK */
#define NFS_CLIENTMAX		( NFS_CLNTMAX + 1)

#define NFS_MOUNTPROG		"mount_nfs"
#ifdef NFS_CLNTUDP
#define NFS_MOUNTOPTS		"-U2"
#else /* !NFS_CLNTUDP */
#define NFS_MOUNTOPTS		"-T2"
#endif /* !NFS_CLNTUDP */
#define MASTER_PORT		500
#define NFSD_PORT		501

#include <stdio.h>
#include <stdlib.h> /* getenv, exit */
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef DEBUG
#define	RPC_SVC_FG
#endif
#ifndef lint
/*static char sccsid[] = "from: @(#)nfs_prot.x 1.2 87/10/12 Copyr 1987 Sun Micro";*/
/*static char sccsid[] = "from: @(#)nfs_prot.x	2.1 88/08/01 4.0 RPCSRC";*/
static char rcsid[] = "$Id: nfs_prot_svc.c,v 1.5 2004/03/24 12:47:41 evgeny Exp $";
#endif /* not lint */

static pid_t cntl_pid = -1;

static void msg( int set_id, int msg_id, ...)
{
 static nl_catd catd = (nl_catd) -1;

 if( catd == (nl_catd) -1){
   char name[256];
   
   if( getcwd( name, sizeof( name)) != NULL){
     strcat( name, "/");
     strcat( name, NFS_CATFILE);
     if(( catd = catopen( name, 0)) == (nl_catd) -1)
       catd = catopen( NFS_CATFILE, 0);
   }
 }
 if( catd != (nl_catd) -1){
   char *msg = catgets( catd, set_id, msg_id,
   	"   \n");
   va_list ap;
   
   va_start( ap, msg_id);
   vprintf( msg, ap);
   va_end( ap);
 }
}
#define msgflush()	fflush(stdout);

static struct in_addr local_addr_list[16];
static int local_addr_num = 0;
static inline void local_addr_add( char **addr_list)
{
 while(( *addr_list != NULL) && ( local_addr_num < 16))
   bcopy( *( addr_list ++), local_addr_list + ( local_addr_num ++), sizeof( struct in_addr));
}

CLIENT *clnt;
typedef struct {
  CLIENT	*clnt;
  char		*name;
  int		retry;
} clnts_t;
static clnts_t clnts[NFS_CLNTMAX];
static int clnts_num = 0;

static SVCXPRT *local_transp = NULL;
static int local_fd = -1;
static int fdtablesize = 0;
static bool_t clntlock[NFS_LOCKPROCNUM] = {
	0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
};

static bool_t nfs_externlockflag = FALSE;
static char nfs_externlockname[32] = "";

struct timeval TIMEOUT = NFS_CLNTTIMEOUT;

#define	NFSPROC_ADMIN ((unsigned long)(100))

typedef enum {
	NFSADMIN_NULL = 0,
	NFSADMIN_OK = 1,
	NFSADMIN_ERROR = 2,
	NFSADMIN_CONNECT = 3,
	NFSADMIN_CLOSE = 4,
	NFSADMIN_LOCK = 5,
	NFSADMIN_UNLOCK = 6
} nfsadmin;

bool_t
xdr_nfsadmin(xdrs, objp)
	register XDR *xdrs;
	nfsadmin *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp))
		return (FALSE);
	return (TRUE);
}

static nfsadmin *
nfsproc_admin(argp, null, clnt)
	nfsadmin *argp;
	void *null;
	CLIENT *clnt;
{
	register bool_t fhflag = nfs_fhflag;
	static nfsadmin clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	nfs_fhflag = TRUE;
	if (clnt_call(clnt, NFSPROC_ADMIN,
		(xdrproc_t) xdr_nfsadmin, (caddr_t) argp,
		(xdrproc_t) xdr_nfsadmin, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		nfs_fhflag = fhflag;
		return (NULL);
	}
	nfs_fhflag = fhflag;
	return ((void *)&clnt_res);
}

#define	NFSPROC_ADDCLIENT ((unsigned long)(101))

struct addclientargs {
  u_int port;
  u_int addr;
  nfs_fh rootfh;  
};
typedef struct addclientargs addclientargs;

bool_t
xdr_nfsaddclient(xdrs, objp)
	register XDR *xdrs;
	addclientargs *objp;
{
	if (!xdr_u_int(xdrs, (u_int*)&objp->port))
		return (FALSE);
	if (!xdr_u_int(xdrs, (u_int*)&objp->addr))
		return (FALSE);
	if (!xdr_opaque(xdrs, (char *)&objp->rootfh, sizeof(objp->rootfh)))
		return (FALSE);
	return (TRUE);
}

static nfsadmin *
nfsproc_addclient(argp, null, clnt)
	addclientargs *argp;
	void *null;
	CLIENT *clnt;
{
	static nfsadmin clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NFSPROC_ADDCLIENT,
		(xdrproc_t) xdr_nfsaddclient, (caddr_t) argp,
		(xdrproc_t) xdr_nfsadmin, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return ((void *)&clnt_res);
}

typedef struct {
  struct sockaddr_in	addr;
  nfs_fh		rootfh;
  u_long		xid;
  bool_t		isExtern;
} client_t;
static client_t client[NFS_CLIENTMAX];
static int client_num = 0;
static int out_client_num = 0;
static char* stub_fh = "     \
  ";

static int client_add( struct sockaddr_in *inetaddr, nfs_fh* fh, bool_t external)
{
 if( client_num > 0){
   register int i = 0;
   
   do
     if( !memcmp( inetaddr, &client[i].addr, sizeof( struct sockaddr_in)))
       return i;
   while((++ i) < client_num);
 }
 if( client_num < NFS_CLIENTMAX){
   bcopy( inetaddr, &client[client_num].addr, sizeof( struct sockaddr_in));
   if (fh)
     bcopy(fh, &client[client_num].rootfh, sizeof(nfs_fh));
   else
     bcopy(stub_fh, &client[client_num].rootfh, sizeof(nfs_fh));
   client[client_num].isExtern = external;
#ifdef DEBUG
   fprintf( stderr, "\t :\t%s:%hu\n",
     inet_ntoa( inetaddr->sin_addr.s_addr), ntohs( inetaddr->sin_port));
   nfs_printfh(" :\t", &client[client_num].rootfh);
#endif
   return (++ client_num);
 }
 return -1;
}

static int client_del( struct sockaddr_in *inetaddr)
{
 if( client_num > 1) {
   register int i = 1;
    
   do
     if( !memcmp( inetaddr, &client[i].addr, sizeof( struct sockaddr_in))){
       while((++ i) < client_num)
         bcopy( client + i, client + i - 1, sizeof( client_t));
       client_num --;
       return 0;
     }
   while((++ i) < client_num);
 }
 return -1;
}

static SVCXPRT *extern_transp = NULL;
static SVCXPRT *master_transp = NULL;
static sigset_t io_sigset;
//static fd_set io_fds;
static bool_t nfs_lockflag = FALSE;
static long nfsdport = NFSD_PORT;

static void
nfs_program_2(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union argument_u {
		nfs_fh nfsproc_getattr_2_arg;
		sattrargs nfsproc_setattr_2_arg;
		diropargs nfsproc_lookup_2_arg;
		nfs_fh nfsproc_readlink_2_arg;
		readargs nfsproc_read_2_arg;
		writeargs nfsproc_write_2_arg;
		createargs nfsproc_create_2_arg;
		diropargs nfsproc_remove_2_arg;
		renameargs nfsproc_rename_2_arg;
		linkargs nfsproc_link_2_arg;
		symlinkargs nfsproc_symlink_2_arg;
		createargs nfsproc_mkdir_2_arg;
		diropargs nfsproc_rmdir_2_arg;
		readdirargs nfsproc_readdir_2_arg;
		nfs_fh nfsproc_statfs_2_arg;
		nfsadmin admin;
		addclientargs addclient_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)( void *, void *, CLIENT *);
	union result_u {
		attrstat nfsproc_getattr_2_res;
		attrstat nfsproc_setattr_2_res;
		diropres nfsproc_lookup_2_res;
		readlinkres nfsproc_readlink_2_res;
		readres nfsproc_read_2_res;
		attrstat nfsproc_write_2_res;
		diropres nfsproc_create_2_res;
		nfsstat nfsproc_remove_2_res;
		nfsstat nfsproc_rename_2_res;
		nfsstat nfsproc_link_2_res;
		nfsstat nfsproc_symlink_2_res;
		diropres nfsproc_mkdir_2_res;
		nfsstat nfsproc_rmdir_2_res;
		readdirres nfsproc_readdir_2_res;
		statfsres nfsproc_statfs_2_res;
	} clnt_res;
	CLIENT *clnt_result = clnt;
	struct sockaddr_in *caller = svc_getcaller( transp);
	register bool_t call_flag = FALSE;
	register bool_t externcall_flag = FALSE;
	register bool_t externclient_flag = FALSE;
	register u_long proc = rqstp->rq_proc;
#ifdef NFS_CLNTUDP
	register u_long	xid = *((u_long *)(((u_int *) transp->xp_p2) + 1));
#endif /* NFS_CLNTUDP */

        if((local_fd == -1) && (proc == NFSPROC_GETATTR)){
          client_add( caller, &argument.nfsproc_getattr_2_arg, FALSE);
          local_fd = transp->xp_fd;
	  (void) pmap_unset(NFS_PROGRAM, NFS_VERSION);
#ifdef NFS_CLNTUDP
	{
	int sock;
	struct sockaddr_in local_addr;
	
	if ((sock = socket (PF_INET, SOCK_DGRAM, 0)) == -1) {
	  fprintf( stderr, "::   .\n");
	  exit(1);
	}
	memset( &local_addr, 0, sizeof( struct sockaddr_in));
	local_addr.sin_family = AF_INET;
	local_addr.sin_port = htons( (u_short)nfsdport);
	local_addr.sin_len = sizeof( struct sockaddr_in);
	if (bind(sock, (const struct sockaddr*)&local_addr,
	  local_addr.sin_len) == -1) {
	  fprintf( stderr, "::   .\n");
	  exit(1);
	}

	extern_transp = svcudp_bufcreate(sock, NFS_MAXPACKET, NFS_MAXPACKET);
	}  
#endif /* !NFS_CLNTUDP */
	  sigprocmask( SIG_SETMASK, NULL, &io_sigset);
	  sigaddset( &io_sigset, SIGINT);
	  sigaddset( &io_sigset, SIGQUIT);
	  sigaddset( &io_sigset, SIGTERM);
//	  sigaddset( &io_sigset, SIGIO);
/*          FD_ZERO( &io_fds);
#ifdef NFS_CLNTUDP
	  FD_SET( extern_transp->xp_fd, &io_fds);
          if(fcntl( extern_transp->xp_fd, F_SETOWN, getpid()) < 0) {
            fprintf( stderr, ":    \n");
            exit(1);
          }

#endif  NFS_CLNTUDP */
        }
	switch ( proc) {
	case NFSPROC_NULL:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) nfsproc_null_2;
		break;

	case NFSPROC_GETATTR:
		xdr_argument = xdr_nfs_fh;
		xdr_result = xdr_attrstat;
		local = (char *(*)()) nfsproc_getattr_2;
		break;

	case NFSPROC_SETATTR:
		xdr_argument = xdr_sattrargs;
		xdr_result = xdr_attrstat;
		local = (char *(*)()) nfsproc_setattr_2;
		break;

	case NFSPROC_ROOT:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) nfsproc_root_2;
		break;

	case NFSPROC_LOOKUP:
		xdr_argument = xdr_diropargs;
		xdr_result = xdr_diropres;
		local = (char *(*)()) nfsproc_lookup_2;
		break;

	case NFSPROC_READLINK:
		xdr_argument = xdr_nfs_fh;
		xdr_result = xdr_readlinkres;
		local = (char *(*)()) nfsproc_readlink_2;
		break;

	case NFSPROC_READ:
		xdr_argument = xdr_readargs;
		xdr_result = xdr_readres;
		local = (char *(*)()) nfsproc_read_2;
		break;

	case NFSPROC_WRITECACHE:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) nfsproc_writecache_2;
		break;

	case NFSPROC_WRITE:
		xdr_argument = xdr_writeargs;
		xdr_result = xdr_attrstat;
		local = (char *(*)()) nfsproc_write_2;
		break;

	case NFSPROC_CREATE:
		xdr_argument = xdr_createargs;
		xdr_result = xdr_diropres;
		local = (char *(*)()) nfsproc_create_2;
		break;

	case NFSPROC_REMOVE:
		xdr_argument = xdr_diropargs;
		xdr_result = xdr_nfsstat;
		local = (char *(*)()) nfsproc_remove_2;
		break;

	case NFSPROC_RENAME:
		xdr_argument = xdr_renameargs;
		xdr_result = xdr_nfsstat;
		local = (char *(*)()) nfsproc_rename_2;
		break;

	case NFSPROC_LINK:
		xdr_argument = xdr_linkargs;
		xdr_result = xdr_nfsstat;
		local = (char *(*)()) nfsproc_link_2;
		break;

	case NFSPROC_SYMLINK:
		xdr_argument = xdr_symlinkargs;
		xdr_result = xdr_nfsstat;
		local = (char *(*)()) nfsproc_symlink_2;
		break;

	case NFSPROC_MKDIR:
		xdr_argument = xdr_createargs;
		xdr_result = xdr_diropres;
		local = (char *(*)()) nfsproc_mkdir_2;
		break;

	case NFSPROC_RMDIR:
		xdr_argument = xdr_diropargs;
		xdr_result = xdr_nfsstat;
		local = (char *(*)()) nfsproc_rmdir_2;
		break;

	case NFSPROC_READDIR:
		xdr_argument = xdr_readdirargs;
		xdr_result = xdr_readdirres;
		local = (char *(*)()) nfsproc_readdir_2;
		break;

	case NFSPROC_STATFS:
		xdr_argument = xdr_nfs_fh;
		xdr_result = xdr_statfsres;
		local = (char *(*)()) nfsproc_statfs_2;
		break;
	
	case NFSPROC_ADMIN:
		xdr_argument = xdr_nfsadmin;
		xdr_result = xdr_nfsadmin;
		break;

	case NFSPROC_ADDCLIENT:
		xdr_argument = xdr_nfsaddclient;
		xdr_result = xdr_nfsadmin;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, (xdrproc_t) xdr_argument, (caddr_t) &argument)) {
		svcerr_decode(transp);
		return;
	}
#ifdef DEBUG
	fprintf( stderr, "%d\t\t(%d)\t%s:%hu\n", proc, call_flag,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
        if( proc == NFSPROC_ADMIN){
          char name[32];
 
          if( transp == local_transp){
            svcerr_systemerr(transp);
#ifdef DEBUG
	    fprintf( stderr, "%d\t \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
            goto reject;
          }
          sprintf( name, "%s:%hu", inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
          switch( argument.admin){
            case NFSADMIN_CONNECT:
            {  
              register int i = client_add( caller, 0, FALSE);
              
              if( i < 0)
                argument.admin = NFSADMIN_ERROR;
              else {
                if( i == client_num){
                  msg( 1, 13, name);
                  msgflush();
                }
                argument.admin = NFSADMIN_OK;
              }
              break;
            }
            case NFSADMIN_CLOSE:
              if( client_del( caller)){
                msg( 2, 16, name);
                argument.admin = NFSADMIN_ERROR;
              }
              else {
                msg( 1, 18, name);
                argument.admin = NFSADMIN_OK;
              }
              msgflush();
              break;
            case NFSADMIN_LOCK:
              nfs_externlockflag = TRUE;
              strcpy( nfs_externlockname, name);
              argument.admin = NFSADMIN_OK;
              msg( 1, 14, name);
              msgflush();
              break;
            case NFSADMIN_UNLOCK:
	      nfs_externlockflag = FALSE;
              argument.admin = NFSADMIN_OK;
	      msg( 1, 15, name);
	      msgflush();
              break;
            default:
              argument.admin = NFSADMIN_ERROR;
          }
	  if( !svc_sendreply(transp, (xdrproc_t) xdr_result, (caddr_t) &argument)) {
	    svcerr_systemerr(transp);
	  }
          goto reject;
        }
	if( proc == NFSPROC_ADDCLIENT){
          struct sockaddr_in caddr;
          unsigned char *s = (unsigned char *) &argument.addclient_arg.rootfh;
          register i = 0;	  

	  nfsadmin result = NFSADMIN_OK;

          memset( &caddr, 0, sizeof( struct sockaddr_in));
          caddr.sin_family = AF_INET;
          caddr.sin_addr.s_addr = htonl(argument.addclient_arg.addr);
          caddr.sin_port = htons(argument.addclient_arg.port);
          caddr.sin_len = sizeof( struct sockaddr_in);
#ifdef DEBUG
	  fprintf (stderr, "  NFSPROC_ADDCLIENT\n");
	  fprintf (stderr, "%s(%d)\n", inet_ntoa(caddr.sin_addr),
	    ntohs(caddr.sin_port));
	  nfs_printfh(" :\t", &argument.addclient_arg.rootfh);
#endif
	  if (client_add(&caddr, &argument.addclient_arg.rootfh, TRUE) == -1)
	    result = NFSADMIN_ERROR;

	  if( !svc_sendreply(transp, (xdrproc_t) xdr_result, (caddr_t) &result)) {
	    svcerr_systemerr(transp);
	  }
          goto reject;
	}

	if( !memcmp( caller, &client->addr, sizeof( struct sockaddr_in))) {
	  bcopy(stub_fh, &client_fh, sizeof(nfs_fh));
	  externcall_flag = FALSE;
	  externclient_flag = FALSE;
	}
	else {
          int i = 0;

          while((( ++i) < client_num) &&
            memcmp( caller, &client[i].addr, sizeof( struct sockaddr_in)));
	    
          if ((i >= client_num) && client_num) {
            if (proc == NFSPROC_NULL) {
  	      externcall_flag = FALSE;
	      externclient_flag = FALSE;
	    }
            else if (proc == NFSPROC_GETATTR) {
              addclientargs arg;
              nfsadmin *result;
	      int c = 0;
   
              arg.addr = ntohl(caller->sin_addr.s_addr); /***/
              arg.port = ntohs(caller->sin_port);
              bcopy(&argument, &arg.rootfh, sizeof(nfs_fh));
    
	      for (c; c < clnts_num; c++)
                if((( result = nfsproc_addclient( &arg, NULL, clnts[c].clnt)) == NULL) ||
                  ( *result != NFSADMIN_OK))
                  fprintf (stderr, "   !\n");
                else
                  fprintf (stderr, "  !\n");
              if (client_add (caller, &argument.nfsproc_getattr_2_arg, TRUE) == -1) {
		msg (2, 13, inet_ntoa( caller->sin_addr.s_addr));
                goto reject;
              }
	      else {
	        externcall_flag = FALSE;	    
	        externclient_flag = TRUE;
              }
	    }
	    else {    
#ifdef DEBUG
	      fprintf( stderr, "%d\t \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
              goto reject;
	    }
	  }
	  else if (client_num) {
	    externcall_flag = !client[i].isExtern;	    
	    externclient_flag = client[i].isExtern;
	  }
	  if (i >= client_num)
	    bcopy(stub_fh, &client_fh, sizeof(nfs_fh));
	  else
	    bcopy(&client[i].rootfh, &client_fh, sizeof(nfs_fh));
	}
	call_flag = clntlock[proc];
        if(( clnts_num <= 0) || ( call_flag == 0) || externcall_flag) {
          register int i = 0;
            
          if( externcall_flag){
            if( transp == local_transp){
              svcerr_systemerr(transp);
#ifdef DEBUG
	      fprintf( stderr, "%d\t \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
	      fprintf( stderr, "%d\t \t%s:%hu\n", proc,
		inet_ntoa( client->addr.sin_addr.s_addr), ntohs( client->addr.sin_port));
#endif
              goto reject;
            }
            while((( ++i) < client_num) &&
            	memcmp( caller, &client[i].addr, sizeof( struct sockaddr_in)));
          }
#ifdef NFS_CLNTUDP
/****!!!!!!!!!!!!!!!!!!!!!****/
	  if(client[i].xid == xid){
#ifdef DEBUG
	    fprintf( stderr, "%d\t \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
            goto reject;
	  }
/***************/	  
	  client[i].xid = xid;
#endif /* NFS_CLNTUDP */
          nfs_fhflag = FALSE;
/* write*/
	  if (proc == NFSPROC_WRITE) {
            static attrstat* local_write (writeargs arg);
            result = (char*) local_write (argument.nfsproc_write_2_arg);
	  }
	  else
            result = (*local)(&argument, &clnt_res, clnt);
        }
        else {
          union argument_u call_argument;
          register u_int i = 0, j = 0;

#ifdef NFS_CLNTUDP
/********/
          while((j < client_num) &&
            memcmp( caller, &client[j].addr, sizeof( struct sockaddr_in)))
	    j++;
	  if (j < client_num) {
	    if (client[j].xid == xid) {
#ifdef DEBUG
  	      fprintf( stderr, "%d\t   \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
              goto reject;
	    }
	    if ((client[j].isExtern == FALSE) && j) {
#ifdef DEBUG
  	      fprintf( stderr, "%d\t:    \t%s:%hu\n", proc,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
#endif
              goto reject;
	    }
	  }
	  else {
	    fprintf (stderr, ":   !\t%s:%hu\n",
	      inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port));
            goto reject;
	  }
/********/
#endif /* NFS_CLNTUDP */
          if( nfs_lockflag){
#ifdef DEBUG
	    fprintf( stderr, "%d\t ()\n", proc);
#endif
            goto reject;
          }
          nfs_lockflag = TRUE;
          bcopy( &argument, &call_argument, sizeof( argument));
          nfs_fhflag = TRUE;
          do {
            register bool_t retry_flag = TRUE;
            register int retry_count = clnts[i].retry;
retry:
#ifdef DEBUG
	    fprintf( stderr, "%d\t.\t%s\n", proc, clnts[i].name);
#endif
            if(( result = (*local)(&argument, &clnt_res, clnts[i].clnt)) == NULL){
	      if( retry_count > 0){
#ifdef DEBUG
	        fprintf( stderr, "%d\t. \t(%d)\n", proc, retry_count);
#endif
	        retry_count--;
	        bcopy( &call_argument, &argument, sizeof( argument));
	        goto retry;
	      }
	      else
#ifdef NFS_CLNTUDP
	        if( retry_count == 0){
#endif /* !NFS_CLNTUDP */
                  static int clnt_del( int i);
                  
#ifdef DEBUG
	          fprintf( stderr, "%d\t \t%s\n", proc, clnts[i].name); fflush( stderr);
#endif
	          if( !clnt_del( i) && ( i < clnts_num)){
	            retry_flag = TRUE;
	            retry_count = clnts[i].retry;
	            bcopy( &call_argument, &argument, sizeof( argument));
	            goto retry;
	          }
	        }
#ifdef DEBUG
	      fprintf( stderr, "%d\t\n", proc);
#endif
              nfs_lockflag = FALSE;
              goto reject;
            }
	    switch((int) *((nfsstat *) result)){
              case NFS_OK:
                break;
              case NFSERR_EXIST:
                if( proc == NFSPROC_MKDIR)
                  break;
                goto default_error;
              case NFSERR_NOENT:
                if(( proc == NFSPROC_RMDIR) || ( proc == NFSPROC_REMOVE) ||
                	( proc == NFSPROC_RENAME))
                  break;
                goto default_error;
              case NFSERR_STALE:
                if(( proc == NFSPROC_RMDIR) || ( proc == NFSPROC_REMOVE))
                  break;
                if( retry_flag && !nfs_recover((nfs_fh *)&call_argument, clnts[i].clnt) &&
                	(( proc != NFSPROC_RENAME) || !nfs_recover( &call_argument.nfsproc_rename_2_arg.to.dir, clnts[i].clnt)) &&
                	(( proc != NFSPROC_LINK) || !nfs_recover( &call_argument.nfsproc_link_2_arg.to.dir, clnts[i].clnt))){
                  retry_flag = FALSE;
                  goto retry;
                }
#ifdef DEBUG
	        fprintf( stderr, "%d\t \n", proc);
#endif
		goto default_error;
              default:
default_error:
                clnt_result = clnts[i].clnt;
                call_flag = 0;
                goto break_calls;
            }
#ifdef DEBUG
	    fprintf( stderr, "%d\t. (%d)\t%s\n", proc, result != NULL ? *((nfsstat *) result) : -1, clnts[i].name);
#endif
	    clnt_freeres( clnts[i].clnt, (xdrproc_t) xdr_result, result);
            bcopy( &call_argument, &argument, sizeof( argument));
          } while(( ++i) < clnts_num);
break_calls:
          nfs_lockflag = FALSE;
	  if( call_flag){
#ifdef NFS_CLNTUDP
	    client->xid = xid;
#endif /* NFS_CLNTUDP */
#ifdef DEBUG
#endif
            nfs_fhflag = FALSE;
	    if (proc == NFSPROC_WRITE) {
              static attrstat* local_write (writeargs arg);
              result = (char*) local_write (argument.nfsproc_write_2_arg);
	    }
	    else
              result = (*local)(&argument, &clnt_res, clnt);
          }
        }
	if (result != NULL && !svc_sendreply(transp, (xdrproc_t) xdr_result, result)) {
		svcerr_systemerr(transp);
	}
#ifdef DEBUG
	fprintf( stderr, "%d\t\t(%d)\t%s:%hu\n", proc, result != NULL ? *((nfsstat *) result) : -1,
		inet_ntoa( caller->sin_addr.s_addr), ntohs( caller->sin_port)); fflush( stderr);
#endif
	if(( result != NULL) && !clnt_freeres( clnt_result, (xdrproc_t) xdr_result, result)){
		fprintf( stderr, ":     \n");
		exit(1);
	}
reject:
	if (!svc_freeargs(transp, (xdrproc_t) xdr_argument, (caddr_t) &argument)) {
		fprintf( stderr, ":     \n");
		exit(1);
	}
	return;
}

static struct timeval *timeout = NULL;
static struct timeval control_timeout = NFS_CTRLTIMEOUT;
static sigset_t control_sigset;
static bool_t control_flag = FALSE;

static char *addr_parse( char *token, struct sockaddr_in *inetaddr)
{
 if( token != NULL){
   struct hostent *hp;
   u_short port = 0;
#define SEPCHAR	':'
   char *sep = strrchr( token, SEPCHAR);
   
   if( sep != NULL){
     sscanf( sep + 1, "%hu", &port);     
     *sep = 0;
   }
   if(( hp = gethostbyname( token)) == NULL){
     if( sep != NULL) *sep = SEPCHAR;
     msg( 2, 2, token);
   }
   else {
     static char name[32];
     
     if( sep != NULL) *sep = SEPCHAR;
#undef SEPCHAR
     if( inetaddr != NULL){
       memset( inetaddr, 0, sizeof( struct sockaddr_in));
       inetaddr->sin_family = AF_INET;
       bcopy( hp->h_addr, &inetaddr->sin_addr.s_addr, hp->h_length);
       inetaddr->sin_port = htons( port);
       inetaddr->sin_len = sizeof( struct sockaddr_in);
     }
     sprintf( name, ( port > 0) ? "%s:%hu" : "%s",
     	inet_ntoa( *((struct in_addr *) hp->h_addr)), port);
     return name;
   }
 }
 return NULL;
}

bool_t clnt_test( CLIENT *clnt)
{
 register int i;
 
 for( i = 0; i < clnts_num; i++)
   if( clnts[i].clnt == clnt)
     return TRUE;
 return FALSE;
}

static int clnt_find( char *token)
{
 if( clnts_num > 0){
   char *name;
   
   if(( name = addr_parse( token, NULL)) != NULL){
     register int i = 0;
     
     do
       if( !strcmp( name, clnts[i].name))
         return i;
     while((++ i) < clnts_num);
     msg( 2, 5, name);
   }
 }
 else
   msg( 2, 4);
 return -1;
}

#ifdef NFS_CLNTUDP
int clnt_sock = RPC_ANYSOCK;
u_short clnt_port = 0;
#endif /* !NFS_CLNTUDP */

static int clnt_add( char *token)
{
 if( clnts_num >= NFS_CLNTMAX)
   msg( 2, 3);
 else {
   struct sockaddr_in inetaddr;
   char *name;
   
   if(( name = addr_parse( token, &inetaddr)) != NULL){
#ifdef NFS_CLNTUDP
     struct timeval timeout = NFS_CLNTUDPRETRYTIMEOUT;
#endif /* !NFS_CLNTUDP */
     register int i;

     for( i = 0; i < clnts_num; i++)
       if( !strcmp( name, clnts[i].name)){
         msg( 2, 11, name);
         return 0;
       }
#ifdef NFS_CLNTUDP
     if((clnt_sock == RPC_ANYSOCK) && ((clnt_sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)){
       fprintf( stderr, "%s::   .\n");
       exit(1);
     }
     clnts[i].clnt = clntudp_bufcreate( &inetaddr, NFS_PROGRAM, NFS_VERSION,
	timeout, &clnt_sock, NFS_MAXPACKET, NFS_MAXPACKET);
#endif /* !NFS_CLNTUDP */
     
     if ( clnts[i].clnt == (CLIENT *) NULL) {
       clnt_pcreateerror( name);
     }
     else {
       nfsadmin argument = NFSADMIN_CONNECT, *result;
       register int j;

       for( j = 0; j < clnts_num; j++){
         struct sockaddr_in clnt_inetaddr;

         clnt_control( clnts[j].clnt, CLGET_SERVER_ADDR, (char*)&clnt_inetaddr);
         if( !memcmp( &inetaddr, &clnt_inetaddr, sizeof( struct sockaddr_in))){
	   clnt_destroy( clnts[i].clnt);
           msg( 2, 11, name);
           return 0;
         }
       }
       for( j = 0; j < local_addr_num; j++)
         if( !memcmp( &inetaddr.sin_addr.s_addr, local_addr_list + j,
         	sizeof( struct in_addr))){
           if(( htons( local_transp->xp_port) == inetaddr.sin_port) 
		|| ( htons( extern_transp->xp_port) == inetaddr.sin_port)){
	     clnt_destroy( clnts[i].clnt);
             msg( 2, 15, name);
             return -1;
           }
           break;
         }
       clnts[i].clnt->cl_auth = clnt->cl_auth;
       if((( result = nfsproc_admin( &argument, NULL, clnts[i].clnt)) == NULL) ||
       		( *result != NFSADMIN_OK)){
	 clnt_perror( clnts[i].clnt, name);
	 clnt_destroy( clnts[i].clnt);
       }
       else {
         int c = 0;
       
	 clnts[i].name = malloc( strlen( name) + 1);
	 strcpy( clnts[i].name, name);
	 clnts[i].retry = NFS_CLNTRETRY;
	 clnts_num ++;
/**    */
	 for (c; c < client_num; c++)
	   if (client[c].isExtern) {
              addclientargs arg;
              nfsadmin *result;
   
              arg.addr = ntohl(client[c].addr.sin_addr.s_addr);
              arg.port = ntohs(client[c].addr.sin_port);
              bcopy(&client[c].rootfh, &arg.rootfh, sizeof(nfs_fh));
              if((( result = nfsproc_addclient( &arg, NULL, clnts[i].clnt)) == NULL) ||
                  ( *result != NFSADMIN_OK))
                  fprintf (stderr, "   !\n");
              else
                fprintf (stderr, "  !\n");
	   }
/***/	
	 msg( 1, 1, clnts[i].name);
	 return 0;
       }
     }
   }
 }
 return -1;
}

static bool_t nfs_recoverflag = FALSE;
static bool_t nfs_recoverhardflag = TRUE;
static clnts_t *clnt_recover = NULL;

inline int clnt_recoverstop()
{
 if( nfs_recoverflag){
   nfsadmin argument = NFSADMIN_UNLOCK, *result;

   if((( result = nfsproc_admin( &argument, NULL, clnt_recover->clnt)) == NULL) ||
 	( *result != NFSADMIN_OK)){
     msg( 2, 8, clnt_recover->name);
   }
   nfs_recoverhardflag = TRUE;
   clnt_recover = NULL;
   timeout = NULL;
   nfs_recoverflag = FALSE;
   return TRUE;
 }
 else
   return FALSE;
}

static int clnt_del( int i)
{
 if(( i >= 0) && ( i < clnts_num)){
   nfsadmin argument = NFSADMIN_CLOSE, *result;
   register int j;

   if( &clnts[i] == clnt_recover){
     msg( 1, 6, clnts[i].name);
     clnt_recoverstop();
   }
   if((( result = nfsproc_admin( &argument, NULL, clnts[i].clnt)) == NULL) ||
     	( *result != NFSADMIN_OK)){
     msg( 2, 14, clnts[i].name);
   }
   clnt_destroy( clnts[i].clnt);
   msg( 1, 2, clnts[i].name);
   free( clnts[i].name);
   while(( ++i) < clnts_num)
     bcopy( &clnts[i], &clnts[i - 1], sizeof( clnts_t));
   clnts_num --;
   return 0;
 }
 return -1;
}

static int clnt_recoverstart( int i)
{
 nfsadmin argument = NFSADMIN_CONNECT, *result;
 nfs_fh *fh;

 if( nfs_externlockflag){
   msg( 2, 6);
   return -1;
 }
 if(( i >= 0) && ( i < clnts_num)){
   nfsadmin argument = NFSADMIN_LOCK, *result;

   if((( result = nfsproc_admin( &argument, NULL, clnts[i].clnt)) == NULL) ||
   	( *result != NFSADMIN_OK)){
     msg( 2, 7, clnts[i].name);
     return -1;
   }
   if(( fh = nfs_fhseq( TRUE)) == NULL){
     return -1;
   }
   clnt_recover = &clnts[i];
   timeout = &control_timeout;
   nfs_recoverflag = TRUE;
 }
 else
   fh = nfs_fhseq( FALSE);
 if( clnt_recover != NULL){
   if( fh == NULL){
     msg( 1, 7, clnt_recover->name);
     clnt_recoverstop();
   }
   else {
     diropargs argument;
     attrstat result;
     register int retry_count = clnt_recover->retry;

#ifdef DEBUG
     nfs_printfh( ".:", fh); fflush( stderr);
#endif
retry:
     bcopy( fh, &argument, NFS_FHSIZE);
     nfs_fhflag = TRUE;
     if( nfsproc_getattr_2( &argument, &result, clnt_recover->clnt) != NULL){
       if(( result.status != NFS_OK) ||
       		( nfs_recoverhardflag && ( result.attrstat_u.attributes.type == NFREG))){
         if( nfs_recover( fh, clnt_recover->clnt)){
#ifdef DEBUG
           fprintf( stderr, ".: :\t\t%s\n", clnt_recover->name);
#endif
	   return -1;
         }
       }
       clnt_freeres( clnt_recover->clnt, (xdrproc_t) xdr_diropres, (char *) &result);
     }
     else {
       if( retry_count > 0){
#ifdef DEBUG
	 fprintf( stderr, ".: .  #%d\t%s\n", retry_count, clnt_recover->name);
#endif
	 retry_count --;
	 goto retry;
       }
       else
	 if( retry_count == 0){
           register int i;
           
           for( i = 0; i < clnts_num; i++)
             if( &clnts[i] == clnt_recover){
               clnt_del( i);
               break;
             }
         }       
#ifdef DEBUG
       fprintf( stderr, ".:  :\t%s\n", clnt_recover->name);
#endif
       return -1;
     }
   }
 }
 return 0;
}

static char *mount_dir = NULL;
static char local_dir[FILENAME_MAX];
static u_int dirlen; 

static void quit( int sig)
{       
	sigset_t set;
	int status;

        if((sig == SIGCHLD) && ((cntl_pid == -1) ||
        	(waitpid(cntl_pid, &status, WNOHANG)  != cntl_pid))){
#ifdef DEBUG
          fprintf( stderr, "  \n"); fflush( stderr);
#endif
          return;
        }
	sigfillset( &set);
	sigprocmask( SIG_SETMASK, &set, NULL);
	if( mount_dir != NULL){
          msg( 1, 12, mount_dir);
	  if( unmount( mount_dir, 0)){
            msg( 2, 9, mount_dir);
	  }
	  msgflush();
	}
	if( local_transp != NULL){
	  svc_unregister(NFS_PROGRAM, NFS_VERSION);
	  if( extern_transp != NULL){
	    svc_destroy(extern_transp);
	    svc_unregister(NFS_PROGRAM, NFS_VERSION);
	  }
#ifdef NFS_LOCK
          nfs_unlock();
#endif /* NFS_LOCK */
	  svc_destroy( local_transp);
	}
	while( clnts_num > 0)
	  clnt_del( 0);
	if(clnt != NULL)
	  clnt_destroy(clnt);
#ifdef NFS_CLNTUDP
        if(clnt_sock != RPC_ANYSOCK)
          close(clnt_sock);
#endif /* !NFS_CLNTUDP */
	nfs_fhclose();
	if(cntl_pid != -1){
	  msgflush();
	  sleep(NFS_CNTLTIMEOUT);
	  kill(cntl_pid, SIGTERM);
	}
	exit(0);
}

static int update_count = NFS_UPDATEDEFAULT;
static int update_countreq = NFS_UPDATEREQDEFAULT;

static void control( void)
{
 bool_t fhflag = nfs_fhflag;
 
 if( nfs_lockflag)
   return;
 sigprocmask( SIG_BLOCK, &control_sigset, NULL);
 nfs_lockflag = TRUE;
 nfs_fhflag = TRUE;
 if( feof( stdin) || ( ferror( stdin) && (cntl_pid != -1)))
   clearerr( stdin);
 nfs_controllex();
 if( !nfs_recoverflag)
   timeout = NULL;
 control_flag = FALSE;
 nfs_fhflag = fhflag;
 nfs_lockflag = FALSE;
 msgflush();
 sigprocmask( SIG_UNBLOCK, &control_sigset, NULL);
}

static void control_handler( int sig)
{
 if(local_fd == -1){
   static int retry = 10;
   
   if((retry --) <= 0)
     quit(SIGTERM);
   msg( 2, 23);
   msgflush();
 }
 else {
   timeout = &control_timeout;
   control_flag = TRUE;
 }
// signal( sig, control_handler);
}

#ifdef ferror
#undef ferror
#endif
#define ferror(stream)	((stream == stdin) && (cntl_pid == -1) ? ferror(stream) : 0)
#include "nfs_control.c"

#define NFS_EXIT(status)	\
	if(cntl_pid != -1) { \
	  int cntl_status; \
	  kill(cntl_pid, SIGTERM); \
	  waitpid(cntl_pid, &cntl_status, WNOHANG); \
	} \
	exit(status)

#include <unistd.h>

main( int argc, char *argv[])
{
  register SVCXPRT *transp;
  pid_t mount_pid = -1;
  struct hostent *hp;
  char host[256];
  char *cntl_proc;
  int exit_flag = 0;

/*  int ch;
  while ((ch = getopt(argc, argv, "hp:v")) != -1)
    switch (ch) {
      case 'h':
	fprintf(stderr, ":\n  %s [<>] [<    >]\n" \
          ":\n" \
          "\t-h\t\t \n" \
          "\t-v\t\t  \n" \
          "\t-p port\t\t   nfsd\n" \
          ":\n" \
          "\t%s\t\t  \n", argv[0], NFS_CNTLENV);
          exit_flag = 1;
          break;
      case 'p':
        nfsdport = strtol (optarg, (char**)NULL, 10);
	break;
      case 'v':
      default:
        fprintf(stderr, "%s:       NFS.\n" \
          "\t:  . : %s\n", argv[0], VERSION);
        exit_flag = 1;
        break;
     }
     if ((nfsdport <= 0) || (nfsdport > (1 << ((sizeof(short) << 3) - 1))))
       nfsdport = NFSD_PORT;

     argc -= optind;
     argv += optind;
*/
	while((argc > 1) && !strncmp(argv[1], "--", 2)){
	  char *option = argv[1] + 2;
	  
	  if(!strcmp(option, "version") || !strcmp(option, "about")){
	    fprintf(stderr, "%s:       NFS.\n" \
	    	"\t:  . : %s\n", argv[0], VERSION);
	    exit_flag = 1;
	  }
	  else if(!strcmp(option, "help") || !strcmp(option, "usage")) {
	    fprintf(stderr, ":\n  %s [<>] [<    >]\n" \
	    	":\n" \
	    	"\t--local-udp\t\t  UDP \n" \
	    	"\t--version, --about\t  \n" \
	    	"\t--help, --usage\t\t \n" \
	    	":\n" \
	    	"\t%s\t\t  \n", argv[0], NFS_CNTLENV);
	    exit_flag = 1;
	  }
	  else break;
	  argv[1] = argv[0];
	  argv ++;
	  argc --;
	}

	if(exit_flag)
	  exit(0);

        if((cntl_proc = getenv(NFS_CNTLENV)) != NULL){
          char cntl_str[NFS_CNTLLENGTH];

          sprintf(cntl_str, cntl_proc, getpid());
          if(strtok(cntl_str, " ") != NULL){
            char *args[NFS_CNTLARGMAX + 1];
            int i = 1, in[2], out[2];

            while((i < NFS_CNTLARGMAX) &&
            	(args[i] = strtok(NULL, " ")) != NULL)
              i ++;
            args[0] = cntl_str;
            args[NFS_CNTLARGMAX] = NULL;
            if((pipe(in) == -1) || (pipe(out) == -1) ||
            	(close(0) == -1) || (close(1) == -1) || (setsid() == -1) ||
            	((cntl_pid = fork()) == -1)){
              fprintf(stderr, "%s::     ()\n", argv[0]);
              exit(-1);
            }
            if(cntl_pid != 0){
              if((dup2(in[0],0) == -1) || (dup2(out[1],1) == -1) ||
              		close(in[0]) || close(in[1]) || close(out[0]) || close(out[1])){
                fprintf(stderr, "%s::     ()\n", argv[0]);
                NFS_EXIT(-1);
              }
              fcntl(0, F_SETFL, O_NONBLOCK);
              fcntl(1, F_SETFL, O_APPEND);
              signal(SIGHUP, SIG_IGN);
              signal(SIGPIPE, quit);
              signal(SIGCHLD, quit);
            }
            else
              if((dup2(out[0],0) == -1) || (dup2(in[1],1) == -1) ||
                	close(in[0]) || close(in[1]) || close(out[0]) || close(out[1]) ||
              	(execv(args[0], args) == -1)){
                fprintf(stderr, "%s::     ()\n", argv[0]);
                exit(-1);
              }
	      else
                fprintf(stderr, "ӣ !\n");
          }
        }

        strcpy( host, "localhost");
	if(( hp = gethostbyname( host)) == NULL){
	  fprintf( stderr, "%s::  : %s.\n", argv[0], host);
	  NFS_EXIT(1);
	}
	else {
	  int sock;
	  struct sockaddr_in inetaddr;
	  struct timeval timeout = NFS_SERVTIMEOUT;
#ifdef NFS_SERVUNIX
	  struct sockaddr addr;

#endif /* !NFS_SERVUNIX */
	  inetaddr.sin_family = AF_INET;
	  bcopy( hp->h_addr, &inetaddr.sin_addr.s_addr, hp->h_length);
	  inetaddr.sin_port = htons( NFS_PORT);
	  inetaddr.sin_len = sizeof( inetaddr);

          if((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	    fprintf( stderr, "%s::   .\n", argv[0]);
	    NFS_EXIT(1);
	  }

	  clnt = clntudp_bufcreate( &inetaddr, NFS_PROGRAM, NFS_VERSION,
	    timeout, &sock, NFS_MAXPACKET, NFS_MAXPACKET);
	}
	if (clnt == (CLIENT *) NULL) {
	  clnt_pcreateerror( host);
	  fprintf( stderr, "%s::    .\n", argv[0]);
	  NFS_EXIT(1);
	}
	clnt->cl_auth = authunix_create_default();
	if( nfsproc_null_2( NULL, NULL, clnt) == NULL){
	  clnt_perror( clnt, host);
	  fprintf( stderr, "%s::    .\n", argv[0]);
	  NFS_EXIT(1);
	}
	local_addr_add( hp->h_addr_list);
	if( !gethostname( host, sizeof( host)) && (( hp = gethostbyname( host)) != NULL))
	  local_addr_add( hp->h_addr_list);

	(void) pmap_unset(NFS_PROGRAM, NFS_VERSION);
#ifdef NFS_CLNTUDP
	transp = svcudp_bufcreate(RPC_ANYSOCK, NFS_MAXPACKET, NFS_MAXPACKET);

	if (transp == NULL) {
		fprintf( stderr, "%s::   udp .\n", argv[0]);
		NFS_EXIT(1);
	}
	if (!svc_register(transp, NFS_PROGRAM, NFS_VERSION, nfs_program_2, IPPROTO_UDP)) {
		fprintf( stderr, "%s::   c (NFS_PROGRAM, NFS_VERSION, udp).\n", argv[0]);
		NFS_EXIT(1);
	}
	local_transp = transp;
#endif /* !NFS_CLNTUDP */

        sigemptyset( &control_sigset);
	sigaddset( &control_sigset, SIGUSR1);
	signal( SIGUSR1, control_handler);
	if( isatty( fileno( stdin))){
	  sigaddset( &control_sigset, SIGINT);
	  signal( SIGINT, control_handler);
	  fprintf( stderr, "%s:   \n", argv[0]);
	}
	else {
	  if(cntl_pid == -1)
	    fseek( stdin, 0L, SEEK_END);
	  signal( SIGINT, quit);
	}
	signal( SIGQUIT, quit); 
	signal( SIGTERM, quit);
	if( argc >= 3){
	  char *argp[argc + 4], port[16];
	  register i;
	  
	  switch( mount_pid = fork()){
	    case -1:
	      fprintf( stderr, "%s::    .\n", argv[0]);
	      quit( SIGTERM);
	    case 0:
	      argp[0] = argv[0];
	      argp[1] = NFS_MOUNTOPTS;
	      argp[2] = "-o";
	      sprintf( port, "port=%d", local_transp->xp_port);
	      argp[3] = port;
	      for( i = 1; i <= argc; i++)
	        argp[i + 3] = argv[i];
	      if( execvp( NFS_MOUNTPROG, argp) == -1){
	        fprintf( stderr, "%s::  .\n", argv[0]);
	        NFS_EXIT(2);
	      }
	    default:
	      mount_dir = argv[argc - 1];
	      strcpy (local_dir, strchr(argv[argc - 2], ':') + 1);
	      strcat (local_dir, "/");
	      dirlen = strlen(local_dir);
	      timeout = &control_timeout;
	  }
	}
#if 0
	svc_run();
	fprintf( stderr, "%s::    svc_run.\n");
	NFS_EXIT(1);
	/* NOTREACHED */
#else
        if(fdtablesize == 0){
          fdtablesize = getdtablesize();
          if(fdtablesize > FD_SETSIZE)
            fdtablesize = FD_SETSIZE;
        }
	for (;;) {
#ifdef NFS_LOCK
	  static int lock = 0, lock_max = NFS_LOCKNUMBER;
	  static u_long proc = 0;
	  static struct timeval lock_timeout = NFS_LOCKTIMEOUT;
#endif /* NFS_LOCK */
	  int mount_status;
	  fd_set readfds = svc_fdset;

	  switch (select( fdtablesize, &readfds, NULL, NULL,
	  		(struct timeval *) timeout)) {
	  case -1:
	  	if (errno == EINTR) {
	  	  continue;
	  	}
		perror("svc_run: - select failed");
		if(cntl_pid != -1) kill(cntl_pid, SIGTERM);
		return;
	  case 0:
		nfs_lockflag = TRUE;
	  	if( nfs_update( update_count) && nfs_recoverflag)
	  	  if( clnt_recoverstart( -1)){
	  	    if( clnt_recover != NULL){
	  	      msg( 2, 21, clnt_recover->name);
		      msg( 1, 6, clnt_recover->name);
		      msgflush();
		    }
	  	    clnt_recoverstop();
	  	  }
		nfs_lockflag = FALSE;
#ifdef NFS_LOCK
		if( lock > 0){
		  nfs_unlock();
		  timeout = NULL;
		  lock = 0;
#ifdef DEBUG
		  fprintf( stderr, "%d\ta: \n", proc); fflush( stderr);
#endif
		}
#endif /* NFS_LOCK */
		break;
	  default:
#ifdef NFS_LOCK
	    if(( clnts_num > 0) && ( lock <= 0) &&
	    	( local_fd > 0) && FD_ISSET( local_fd, &readfds)){
#define PROC_INDEX	6
	      long buf[PROC_INDEX + 1];

              recv( local_fd, &buf, sizeof( buf), MSG_PEEK);
              proc = (u_long) ntohl( buf[PROC_INDEX]);
#undef PROC_INDEX
              if(( proc < 0) || ( proc >= NFS_LOCKPROCNUM))
                proc = 0;
	      if( clntlock[proc]){ 
	        if( nfs_lock()){
                  FD_CLR( local_fd, &readfds);
#ifdef DEBUG
		  fprintf( stderr, "%d\t:  \n", proc); fflush( stderr);
#endif
		}
		else {
		  timeout = &lock_timeout;
		  lock = 1;
#ifdef DEBUG
		  fprintf( stderr, "%d\t: \n", proc);
#endif
		}
              }
	    }
#endif /* NFS_LOCK */
	    nfs_lockflag = TRUE;
	    nfs_update( update_countreq);
	    nfs_lockflag = FALSE;
	    svc_getreqset(&readfds);
#ifdef NFS_LOCK
	    if(( lock > 0) && ((++ lock) > lock_max)){
              nfs_unlock();
	      timeout = NULL;
              lock = 0;
#ifdef DEBUG
	      fprintf( stderr, "%d\ta: \n", proc); fflush( stderr);
#endif
            }
#endif /* NFS_LOCK */
	  }
	  if(( mount_pid != -1) && 
	  	( waitpid( mount_pid, &mount_status, WNOHANG) == mount_pid)){
	    if( !WIFEXITED( mount_status) || ( WEXITSTATUS( mount_status) != 0)){
	      msg( 2, 19, mount_dir);
	      msgflush();
	      mount_dir = NULL;
	      quit( SIGTERM);
	    }
            msg( 1, 11, mount_dir);
            msgflush();
	    mount_pid = -1;
	    timeout = NULL;
	  }
	  if( control_flag && ( mount_pid == -1))
	    control();
	}
#endif
}

struct netbuf nb_udp;

static int tmp_func() {
int ecode;
int sock;
u_int32_t host_addr[4];
struct addrinfo *ai_udp, hints;
//struct nfsd_args nfsdargs;
const char* hostptr;
struct netconfig* nconf_udp;

memset(&hints, 0, sizeof hints);
hints.ai_flags = AI_PASSIVE;
hints.ai_family = AF_INET;
hints.ai_socktype = SOCK_DGRAM;
hints.ai_protocol = IPPROTO_UDP;

ecode = getaddrinfo(hostptr, "nfs", &hints, &ai_udp);
if (ecode != 0) {
  fprintf (stderr, "getaddrinfo: %s", gai_strerror(ecode));
  exit (1);
}

if ((sock = socket(ai_udp->ai_family, ai_udp->ai_socktype,
  ai_udp->ai_protocol)) < 0) {
  fprintf (stderr, "   ");
  exit(1);
}

((struct sockaddr_in *)(void *) ai_udp->ai_addr)->sin_port = htons(1000);

if (bind(sock, ai_udp->ai_addr, ai_udp->ai_addrlen) < 0) {
  fprintf(stderr, "can't bind udp addr");
  exit(1);
}

freeaddrinfo(ai_udp);
/*
nfsdargs.sock = sock;
nfsdargs.name = NULL;
nfsdargs.namelen = 0;
if (nfssvc(NFSSVC_ADDSOCK, &nfsdargs) < 0) {
  fprintf (stderr, "can't Add UDP socket");
  exit(1);
}
(void)close(sock);
*/

memset(&hints, 0, sizeof hints);
hints.ai_flags = AI_PASSIVE;
hints.ai_family = AF_INET;
hints.ai_socktype = SOCK_DGRAM;
hints.ai_protocol = IPPROTO_UDP;
ecode = getaddrinfo(NULL, "nfs", &hints, &ai_udp);
if (ecode != 0) {
  fprintf(stderr, "getaddrinfo udp: %s", gai_strerror(ecode));
  exit(1);
}

((struct sockaddr_in *)(void *) ai_udp->ai_addr)->sin_port = htons(1000);

nconf_udp = getnetconfigent("udp");
if (nconf_udp == NULL)
  err(1, "getnetconfigent udp failed");
nb_udp.buf = ai_udp->ai_addr;
nb_udp.len = nb_udp.maxlen = ai_udp->ai_addrlen;
if (!rpcb_set(RPCPROG_NFS, 2, nconf_udp, &nb_udp))
  err(1, "rpcb_set udp failed");
freeaddrinfo(ai_udp);

return sock;
}

#include <sys/stat.h>

static attrstat* local_write (writeargs arg) {
  static struct stat sb;
  static attrstat result;
  int fd;
  
  if (!nfs_fh2path(&arg.file)) {
    result.status = NFSERR_STALE;
    return &result;
  }
  strcpy(local_dir + dirlen, nfs_fh2path(&arg.file));
  fd = open(local_dir, O_WRONLY);
  if (fd == -1) {
    result.status = NFSERR_NOENT;
    fprintf (stderr, "can't open file\n");
    return &result;
  }
  if (pwrite (fd, arg.data.data_val, arg.data.data_len, arg.offset) == -1) {
    result.status = NFSERR_NOENT;
    return &result;
  }
  close (fd);
  stat(local_dir, &sb);
  memset(&result, 0, sizeof(result));
  result.status = NFS_OK;
  if (S_ISREG(sb.st_mode))
    result.attrstat_u.attributes.type = NFREG;
  else if (S_ISDIR(sb.st_mode))
    result.attrstat_u.attributes.type = NFDIR;
  else if (S_ISBLK(sb.st_mode))
    result.attrstat_u.attributes.type = NFBLK;
  else if (S_ISCHR(sb.st_mode))
    result.attrstat_u.attributes.type = NFCHR;
  else if (S_ISLNK(sb.st_mode))
    result.attrstat_u.attributes.type = NFLNK;
  else if (S_ISSOCK(sb.st_mode))
    result.attrstat_u.attributes.type = NFSOCK;
  else if (S_ISFIFO(sb.st_mode))
    result.attrstat_u.attributes.type = NFFIFO;
  else {
    result.attrstat_u.attributes.type = NFBAD;
    fprintf (stderr, "bad file type\n");
    return &result;
  }
  result.attrstat_u.attributes.mode = sb.st_mode;
  result.attrstat_u.attributes.nlink = sb.st_nlink;
  result.attrstat_u.attributes.uid = sb.st_uid;
  result.attrstat_u.attributes.gid = sb.st_gid;
  result.attrstat_u.attributes.size = sb.st_size;
  result.attrstat_u.attributes.blocksize = 512; /* XXX */
  result.attrstat_u.attributes.rdev = sb.st_rdev;
  result.attrstat_u.attributes.blocks = sb.st_blocks;
  result.attrstat_u.attributes.fsid = 0; /* XXX */
  result.attrstat_u.attributes.fileid = 0; /* XXX */
  result.attrstat_u.attributes.atime.seconds = sb.st_atime;
  result.attrstat_u.attributes.mtime.seconds = sb.st_mtime;
  result.attrstat_u.attributes.ctime.seconds = sb.st_ctime;
    
  return &result;
}
