/*
*         NFS.
*       .
* 
* :  
*          .
* $Id: nfs_recover.c,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $
*/

/*#define DEBUG*/

#include <stdio.h>
#include <string.h>

#include "nfs_fh.h"
#include "nfs_recover.h"

extern CLIENT *clnt;

typedef struct _nfs_update_t {
  CLIENT	*clnt;
  nfs_fh	fh;
  u_int		offset;
  u_int		count;
  struct _nfs_update_t *next;
} nfs_update_t;

static nfs_update_t *update = NULL;

inline int update_add( nfs_fh *fh, u_int size, CLIENT *recover)
{
 nfs_update_t *file;

 if(( file = (nfs_update_t *) malloc( sizeof( nfs_update_t))) == NULL)
   return -1;
 file->clnt = recover;
 bcopy( fh, &file->fh, NFS_FHSIZE);
 file->offset = 0;
 file->count = size;
 file->next = update;
 if( update == NULL)
   update = file;
 return 0;
}

inline nfs_update_t *update_list( u_int count)
{
 if( update != NULL){
   extern bool_t clnt_test( CLIENT *clnt);
 
   if( count > 0){
     update->offset += count;
     update->count = ( update->count > count) ? update->count - count : 0;
   }
   while(( update->count <= 0) || !clnt_test( update->clnt)){
     nfs_update_t *file = update->next;
   
     free( update);
     if(( update = file) == NULL)
       break;
   }
 }
 return update;
}

bool_t nfs_update( int count)
{
 if(( update != NULL) && ( count > 0)){
   readargs read_args;
   readres read_res;
   writeargs write_args;
   attrstat write_res;
   register u_int data_count = 0;
   register int i;

   for( i = 0; ( update_list( data_count) != NULL) && ( i < count); i++){ 
#ifdef DEBUG
     nfs_printfh( ".:", &update->fh);
#endif
     memset( &read_args, 0, sizeof( read_args));
     bcopy( &update->fh, &read_args.file, NFS_FHSIZE);
     read_args.offset = update->offset;
     read_args.count = NFS_MAXDATA;
#ifdef DEBUG
     fprintf( stderr, ".: :\t%d\t%d\n", read_args.offset, read_args.count);
#endif
     nfs_fhflag = FALSE;
     if( nfsproc_read_2( &read_args, &read_res, clnt) == NULL){
#ifdef DEBUG
       fprintf( stderr, ".: ..:\t%d\n", read_args.offset);
#endif
       data_count = update->count;
       continue;
     }
     data_count = read_res.readres_u.reply.data.data_len;
     if(( read_res.status != NFS_OK) || ( data_count == 0)){
#ifdef DEBUG
       fprintf( stderr, ".: ..:\t%d\t(%d)\n", read_args.offset, read_res.status);
#endif
       clnt_freeres( clnt, (xdrproc_t) xdr_readres, (char *) &read_res);
       data_count = update->count;
       continue;
       break;
     }
     else {
#ifdef DEBUG
       fprintf( stderr, ".: :\t%d\t%d\n", read_args.offset, data_count);
#endif
       memset( &write_args, 0, sizeof( write_args));
       bcopy( &update->fh, &write_args.file, NFS_FHSIZE);
       write_args.offset = update->offset;
       bcopy( &read_res.readres_u.reply.data, &write_args.data, sizeof( write_args.data));
       nfs_fhflag = TRUE;
       if( nfsproc_write_2( &write_args, &write_res, update->clnt) == NULL){
         clnt_freeres( clnt, (xdrproc_t) xdr_readres, (char *) &read_res);
         break;
       }
       clnt_freeres( clnt, (xdrproc_t) xdr_readres, (char *) &read_res);
       clnt_freeres( update->clnt, (xdrproc_t) xdr_attrstat, (char *) &write_res);
       if( write_res.status != NFS_OK){
         break;
       }
#ifdef DEBUG
       fprintf( stderr, ".: :\t%d\t%d\n", read_args.offset, data_count);
#endif
     }
   }
 }
 return ( update == NULL);
}

inline void nfs_fattr2sattr( fattr *in, sattr *out)
{
 out->mode = in->mode;
 out->uid = in->uid;
 out->gid = in->gid;
 out->size = in->size;
 out->atime = in->atime;
 out->mtime = in->mtime;
}

static int nfs_recover_reg( nfs_fh *fh, diropargs *args, attrstat *attributes, CLIENT *recover)
{
 createargs argument;
 diropres result;

#ifdef DEBUG
 fprintf( stderr, ".: :\t%s\n", args->name);
#endif
 bcopy( args, &argument.where, sizeof( argument.where));
 nfs_fattr2sattr( &attributes->attrstat_u.attributes, &argument.attributes);
 nfs_fhflag = TRUE;
 if( nfsproc_create_2( &argument, &result, recover) == NULL)
   return -1;
 clnt_freeres( recover, (xdrproc_t) xdr_diropres, (char *) &result);
 if( result.status != NFS_OK){
   if( result.status == NFSERR_ACCES){
#ifdef DEBUG
     fprintf( stderr, ".:  :\t\t%s\t(%d)\n", args->name, result.status);
#endif
     return 0;
   }
   return -1;
 }
#ifdef DEBUG
 fprintf( stderr, ".: :\t\t%s\t(%d)\n", args->name, result.status);
#endif
 update_add( fh, attributes->attrstat_u.attributes.size, recover);
 return 0;
}

static int nfs_recover_lnk( nfs_fh *fh, diropargs *args, attrstat *attributes, CLIENT *recover)
{
 nfs_fh readlink_args;
 readlinkres readlink_res;
 register ret = 0;
 
 bcopy( fh, &readlink_args, NFS_FHSIZE);
 nfs_fhflag = FALSE;
 if( nfsproc_readlink_2( &readlink_args, &readlink_res, clnt) == NULL){
#ifdef DEBUG
   fprintf( stderr, ".: .:\t%s\n", args->name);
#endif
   return -1;
 }
 if( readlink_res.status != NFS_OK){
#ifdef DEBUG
   fprintf( stderr, ".: .:\t%s\t(%d)\n", args->name, readlink_res.status);
#endif
 }
 else {
   symlinkargs argument;
   nfsstat result;

   bcopy( args, &argument.from, sizeof( argument.from));
   argument.to = readlink_res.readlinkres_u.data;
   nfs_fattr2sattr( &attributes->attrstat_u.attributes, &argument.attributes);
   nfs_fhflag = TRUE;
   if( nfsproc_symlink_2( &argument, &result, recover) == NULL){
#ifdef DEBUG
     fprintf( stderr, ".: .:\t%s\n", args->name);
#endif
   }
   else {
     clnt_freeres( recover, (xdrproc_t) xdr_nfsstat, (caddr_t) &result);
     if( result != NFS_OK){
#ifdef DEBUG
       fprintf( stderr, ".: .:\t%s\t(%d)\n", args->name, result);
#endif
     }
     else
       ret = 0;
   }
 } 
 clnt_freeres( clnt, (xdrproc_t) xdr_readlinkres, (char *) &readlink_res);
 return 0;
}

int nfs_recover( nfs_fh *fh, CLIENT *recover)
{
 register bool_t fhflag = nfs_fhflag;
 char path[NFS_MAXPATHLEN];
 nfs_fh create_fh;
 filename name;
 attrstat attributes;
 diropargs args, argument;
 diropres result;
 nfspath pathp = nfs_fh2path( fh);
 register int retval = -1;

 if( pathp == NULL){
#ifdef DEBUG
   nfs_printfh( ".: :", fh);
#endif
   return 0;
 }
#ifdef DEBUG
 fprintf( stderr, ".: :\t%s\n", pathp);
#endif
 bcopy( fh, &create_fh, NFS_FHSIZE);
 nfs_fhflag = FALSE;
 if( nfsproc_getattr_2( &create_fh, &attributes, clnt) == NULL){
#ifdef DEBUG
   fprintf( stderr, ".:  :\t%s\n(%d)\n", pathp, result.status);
#endif
   nfs_fhflag = fhflag;
   return 0;
 }
 if( attributes.status != NFS_OK){
   return 0;
 }
 bcopy( fh, &create_fh, NFS_FHSIZE);
 strcpy( path, pathp);
 nfs_path2fh( "", &args.dir);
 name = strtok( path, "/");
 while(( args.name = name) != NULL){   
   if((( name = strtok( NULL, "/")) == NULL) &&
   	( attributes.attrstat_u.attributes.type != NFDIR)){
     switch( attributes.attrstat_u.attributes.type){
       case NFREG:
         if( nfs_recover_reg( &create_fh, &args, &attributes, recover)){
	   goto error;
	 }
         break;
       case NFLNK:
         if( nfs_recover_lnk( &create_fh, &args, &attributes, recover)){
	   goto error;
	 }
         break;
     }
     break;
   }
#ifdef DEBUG
   fprintf( stderr, ".: :\t%s\n", args.name);
#endif
   bcopy( &args, &argument, sizeof( argument));
   nfs_fhflag = TRUE;
   if( nfsproc_lookup_2( &argument, &result, recover) == NULL)
     goto error;
   if(( result.status != NFS_OK) ||
	( result.diropres_u.diropres.attributes.type != NFDIR)){
     clnt_freeres( recover, (xdrproc_t) xdr_diropres, (char *) &result);
     bcopy( &args, &argument, sizeof( argument));
     nfs_fhflag = FALSE;
     if( nfsproc_lookup_2( &argument, &result, clnt) == NULL)
       goto error;
     if(( result.status != NFS_OK) ||
	( result.diropres_u.diropres.attributes.type != NFDIR)){
#ifdef DEBUG
       fprintf( stderr, ".:  :\t%s\t(%d)\n", argument.name, result.status);
#endif
       clnt_freeres( clnt, (xdrproc_t) xdr_diropres, (char *) &result);
       nfs_fhflag = fhflag;
       return -1;
     }
     else {
       createargs argument;
       
#ifdef DEBUG
       fprintf( stderr, ".:  :\t%s\n", args.name);
#endif
       bcopy( &args, &argument.where, sizeof( argument.where));
       nfs_fattr2sattr( &result.diropres_u.diropres.attributes, &argument.attributes);
       clnt_freeres( clnt, (xdrproc_t) xdr_diropres, (char *) &result);
       nfs_fhflag = TRUE;
       if( nfsproc_mkdir_2( &argument, &result, recover) == NULL)
         goto error;
       if(( result.status != NFS_OK) ||
		( result.diropres_u.diropres.attributes.type != NFDIR)){
         clnt_freeres( recover, (xdrproc_t) xdr_diropres, (char *) &result);
	 goto error;
       }
     }
   }
   bcopy( &result.diropres_u.diropres.file, &args.dir, NFS_FHSIZE);
   clnt_freeres( recover, (xdrproc_t) xdr_diropres, (char *) &result);
 }
 retval = 0;
error:
#ifdef DEBUG
 if( retval){
   fprintf( stderr, ".: :\t\t%s\n", args.name);
 }
#endif
 clnt_freeres( clnt, (xdrproc_t) xdr_attrstat, (char *) &attributes);
 nfs_fhflag = fhflag;
 return retval;
}
