#include "nfs_cntl.h"
#include <stdio.h>
#include <string.h>
#include <netdb.h>

char* command;
reply* result;

#define ADD 1
#define REMOVE 2

main(argc, argv)
	int argc;
	char *argv[];
{
	CLIENT *clnt;
	char *host;
        struct hostent *hp;
	int speccommand;

	if (argc < 2) {
		printf("usage:  %s server_host\n", argv[0]);
		exit(1);
	}
	host = argv[1];

#ifndef	DEBUG
	clnt = clnt_create(host, NFSCNTL_PROG, NFSCNTL_VER, "netpath");
	if (clnt == (CLIENT *) NULL) {
		clnt_pcreateerror(host);
		exit(1);
	}
#endif	/* DEBUG */

	command = (char*) malloc(sizeof(char)*MAXCOMMANDLEN);	
	while ( 1) {
	    speccommand = 0;
	    bzero(command, sizeof(command));
	    if(!fgets(command, MAXCOMMANDLEN, stdin))
		break;
	    if (!strncmp(command, "stop", strlen("stop")))
		break;
	    if (!strncmp(command, "listener ", strlen("listener ")))
		speccommand = ADD;
	    if (!strncmp(command, "dellistener ", strlen("dellistener ")))
		speccommand = REMOVE;
	    if (speccommand) {
		char listener[80];
		int port;
		struct hostent *hp;
		struct addr addr;
		
		sscanf(strchr(command, ' ') + 1, "%s %d", listener, &port);
    		fprintf(stdout, ":  %s  %d\n", listener, port);
		if(( hp = gethostbyname(listener)) == NULL) {
		    fprintf (stderr, "  : %s\n", listener);
		    continue;
		}
		if (port < 0) {
		    fprintf (stderr, "  : %d\n", port);
		    continue;
		}
		addr.port = port;
		memcpy (&addr.addr, hp->h_addr, hp->h_length);
		switch (speccommand) {
		    case ADD:
			add_listener_1 (&addr, clnt);
			break;
		    case REMOVE:
			remove_listener_1 (&addr, clnt);
			break;
		}
		continue;
	    }
	    else {
    		fprintf(stdout, ": %s", command);
    		result = execcommand_1(&command, clnt);
		if (result == (reply *) NULL) {
		    clnt_perror(clnt, "call failed");
		}
	    }
	}

#ifndef	DEBUG
	clnt_destroy(clnt);
#endif		/* DEBUG */
}
