/*
*         NFS.
*         .
* 
* :  
*          .
* $Id: nfs_fh.h,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $
*/

#ifndef _NFS_FH_H
#define _NFS_FH_H

#include "nfs_prot.h"

typedef u_int32_t	nfs_fhhash_t;
typedef int		nfs_fhflags_t;
typedef struct {
  nfs_fhflags_t	flags;
  nfs_fh	fh;
  char		path[NFS_MAXPATHLEN];
} nfs_fhdata_t;

extern bool_t nfs_fhflag;
extern bool_t nfs_fhupdateflag;
extern nfs_fh client_fh;

extern int nfs_virtual2fh( nfs_fh *save_fh, nfs_fh *fh);
extern int nfs_fh2virtual( nfs_fh *save_fh, nfs_fh *fh, filename name);
extern int nfs_fhremove( nfs_fh *save_fh, filename name);
extern nfspath nfs_fh2path( nfs_fh *fh);
extern int nfs_path2fh( nfspath path, nfs_fh *fh);
extern nfs_fh *nfs_fhseq( bool_t start);
extern void nfs_fhupdate( nfs_fh *fh);
extern void nfs_fhrefresh( void);
extern void nfs_printfh( char *msg, nfs_fh *fh);
extern void nfs_fhsync( void);
extern void nfs_fhclose( void);

#endif /* !_NFS_FH_H */
