/*
 * This is sample code generated by rpcgen.
 * These are only templates and you can use them
 * as a guideline for developing your own functions.
 */

#include <signal.h>
#include <syslog.h>
#include <stdio.h>
#include <errno.h>

#include "nfs_cntl.h"

#include <netinet/in.h>

void *
null_1(argp, rqstp)
	void *argp;
	struct svc_req *rqstp;
{
	static char * result;
	
	syslog (LOG_ERR, "  null");
	result = 0;

	return((void *) &result);
}

reply *
execcommand_1(argp, rqstp)
	char **argp;
	struct svc_req *rqstp;
{
	static reply  result;

	syslog (LOG_DEBUG, "  exec,  - %s", *argp);
	fprintf (stdout, "%s", *argp);
    	fflush (stdout);
	kill (ppid, SIGUSR1);
	result.status = OK;

	return (&result);
}


#define MAX_VIEWERS 10

static struct sockaddr_in listeners[MAX_VIEWERS];
static int num_listeners = 0;

int find_listener (int port, long addr) {
  int i;
  
  for (i = 0; i < num_listeners; i++)
    if ((listeners[i].sin_port == port) &&
        (listeners[i].sin_addr.s_addr == addr))
	return i;

  return -1;
}

reply *
add_listener_1(argp, rqstp)
	addr *argp;
	struct svc_req *rqstp;
{
	static reply  result;

	syslog (LOG_DEBUG, "  addv,  - %d,  - %d", 
	    argp->port, argp->addr);
	if (find_listener(argp->port, argp->addr) != -1) {
	  result.status = OK;
	  return (&result);
	}
	if (num_listeners < MAX_VIEWERS) {
	  struct in_addr addr;

	  listeners[num_listeners].sin_family = AF_INET;
	  listeners[num_listeners].sin_port = htons(argp->port);
	  listeners[num_listeners++].sin_addr.s_addr = argp->addr;
	  addr.s_addr = argp->addr;
	  syslog (LOG_INFO, "   - %d,  - %s", 
	    argp->port, inet_ntoa(addr));
	  result.status = OK;
	}
	else {
	  result.status = ERROR;
	}

	return (&result);
}

reply *
remove_listener_1(argp, rqstp)
	addr *argp;
	struct svc_req *rqstp;
{
	static reply  result;

	syslog (LOG_DEBUG, "  remv,  - %d,  - %d", 
	    argp->port, argp->addr);

	int i = find_listener(htons(argp->port), argp->addr);
	if (i != -1) {
	  for (i; i < num_listeners - 1; i++)
	    memcpy (&listeners[i], &listeners[i+1], sizeof(struct sockaddr_in));
	  --num_listeners;
	  syslog (LOG_INFO, "   - %d,  - %d", 
	    argp->port, argp->addr);
	}

	result.status = OK;
	return (&result);
}

void getdata(void) {
  static char nfs_data[MAXERRORLEN];
  int i;
  
  if (fgets(nfs_data, MAXERRORLEN, stdin)) {
    syslog(LOG_DEBUG, ": %s", nfs_data);
    for (i = 0; i < num_listeners; i++)
      sendto (sock, nfs_data, strlen(nfs_data) + 1, 0, 
             (struct sockaddr*) &listeners[i], sizeof(listeners[i]));
  }
  else
    syslog(LOG_ERR, "   fgets:%s", strerror(errno));
}
