/*
*         NFS.
*        .
* 
* :  
*          .
* $Id: nfs_fh.c,v 1.1.1.1 2003/12/04 11:23:12 evgeny Exp $
*/

/*#define DEBUG*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <limits.h>
#include <db.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "nfs_fh.h"

bool_t nfs_fhflag = FALSE;
bool_t nfs_fhupdateflag = TRUE;
nfs_fh client_fh;

#define DB_NAME		NULL /* ".nfs_fh.db" */
#define DB_FLAGS	(O_CREAT | O_EXCL | O_TRUNC | O_RDWR)
#define DB_MODE		(S_IRUSR | S_IWUSR)
#define DB_KEYSIZE	NFS_FHSIZE
#define DB_SETKEY( key, value)		\
	key.data = value; key.size = DB_KEYSIZE
#define DB_HEADSIZE	( sizeof( nfs_fhflags_t) + NFS_FHSIZE)
#define DB_SETDATA( data, value)	\
	data.data = &value;		\
	data.size = DB_HEADSIZE + strlen( value.path) + 1
#define DB_GETFLAGS( d)	(((nfs_fhdata_t *) d.data)->flags)
#define DB_GETFH( d)	&(((nfs_fhdata_t *) d.data)->fh)
#define DB_GETPATH( d)	(((nfs_fhdata_t *) d.data)->path)

static DB *fh_db = NULL;
#if 1
static u_int32_t
hash(keyarg, len)
	const void *keyarg;
	register size_t len;
{
 return *((u_int32_t *) keyarg);
}
#define DB_TYPE		DB_HASH
static HASHINFO fh_info = { 256, 8, 16386, 0, hash};
#else
#define DB_TYPE		DB_BTREE
static BTREEINFO fh_info;
#endif
static nfs_fh root_fh, clnt_root_fh;

int nfs_virtual2fh( nfs_fh *save_fh, nfs_fh *fh)
{
#ifdef DEBUG
 nfs_printfh( "", fh);
#endif
 if( fh_db == NULL){
   nfs_fhdata_t value;
   DBT key, data;

   if(( fh_db = dbopen( DB_NAME, DB_FLAGS, DB_MODE, DB_TYPE, &fh_info)) == NULL){
     return -1;
   }
   bcopy( fh, &clnt_root_fh, NFS_FHSIZE);
   bcopy( fh, &value.fh, NFS_FHSIZE);
   value.path[0] = 0;
   DB_SETDATA( data, value);
   nfs_path2fh( value.path, &root_fh);
   DB_SETKEY( key, &root_fh);
   if( fh_db->put( fh_db, &key, &data, 0) != 0){
     return -1;
   }
#ifdef DEBUG
   nfs_printfh( "", &root_fh);
#endif
   if( save_fh != NULL)
     bcopy( &root_fh, save_fh, NFS_FHSIZE);
 }
 else {
   if( memcmp( fh, &clnt_root_fh, NFS_FHSIZE) && 
       memcmp( fh, &client_fh, NFS_FHSIZE)){
     if( save_fh != NULL)
       bcopy( fh, save_fh, NFS_FHSIZE);
     if( !nfs_fhflag){
       DBT key, data;
      
       DB_SETKEY( key, fh);
       if( fh_db->get( fh_db, &key, &data, 0) != 0){
         if( !nfs_fhupdateflag)
           return -1;
#ifdef DEBUG
         fprintf( stderr, "  \t()\n");
#endif       
         nfs_fhupdate( &root_fh);
#ifdef DEBUG
         fprintf( stderr, "  \t()\n");
#endif
	 if( fh_db->get( fh_db, &key, &data, 0) != 0){
#ifdef DEBUG
/*           fprintf( stderr, " \n"); getchar();*/
           fprintf( stderr, " \n");
#endif
           return -1;
         }
       }
       bcopy( DB_GETFH( data), fh, NFS_FHSIZE);
     }
   }
   else {
     if( save_fh != NULL)
       bcopy( &root_fh, save_fh, NFS_FHSIZE);
     if( nfs_fhflag)
       bcopy( &root_fh, fh, NFS_FHSIZE);
     if( !memcmp( fh, &client_fh, NFS_FHSIZE))
       bcopy( &clnt_root_fh, fh, NFS_FHSIZE);
   }
 }
#ifdef DEBUG
 nfs_printfh( "", fh); fflush( stderr);
#endif
 return 0;
}

int nfs_fh2virtual( nfs_fh *save_fh, nfs_fh *fh, filename name)
{
 nfs_fhdata_t value;
 char *path = value.path;
 nfs_fh virtual_fh;
 DBT key, data;

 if( nfs_fhflag)
   return 0;
 if(( fh_db == NULL) || ( save_fh == NULL))
   return -1;
#ifdef DEBUG
 nfs_printfh( "", save_fh);
 fprintf( stderr, "\t'%s'\n", name);
 nfs_printfh( "", fh);
 fflush( stderr);
#endif
 if( strcmp( name, ".") == 0){
   bcopy( save_fh, fh, NFS_FHSIZE);
#ifdef DEBUG
   nfs_printfh( "", fh);
#endif
   return 0;  
 }
 DB_SETKEY( key, save_fh);
 if( fh_db->get( fh_db, &key, &data, 0) != 0){
#ifdef DEBUG
/*   fprintf( stderr, " \n"); getchar();*/
   fprintf( stderr, " \n");
#endif
   return -1;
 }
 if( strcmp( name, "..") == 0){
   char *dir = strrchr( DB_GETPATH( data), '/');

   if( dir != NULL){
     *dir = 0;
     nfs_path2fh( DB_GETPATH( data), fh);
     *dir = '/';
   }
   else
     bcopy( &root_fh, fh, NFS_FHSIZE);
#ifdef DEBUG
   nfs_printfh( "", fh);
#endif
   return 0;  
 }
 bcopy( fh, &value.fh, NFS_FHSIZE);
 if(( data.size - DB_HEADSIZE) > 1){
   strcpy( path, DB_GETPATH( data)); 
   strcat( path, "/");
   strcat( path, name);
 }
 else
   strcpy( path, name);
 DB_SETDATA( data, value); 
 nfs_path2fh( path, &virtual_fh);
 DB_SETKEY( key, &virtual_fh);
 if( fh_db->put( fh_db, &key, &data, 0) != 0){
#ifdef DEBUG
/*   fprintf( stderr, "   \n"); getchar();*/
   fprintf( stderr, "   \n");
#endif
   return -1;
 }
 bcopy( key.data, fh, NFS_FHSIZE);
#ifdef DEBUG
 fprintf( stderr, "\t'%s'\n", path);
 nfs_printfh( "", fh);
 fflush( stderr);
#endif
 return 0;
}

int nfs_fhremove( nfs_fh *save_fh, filename name)
{
 char path[NFS_MAXPATHLEN];
 nfs_fh virtual_fh;
 DBT key, data;
 
 if(( fh_db == NULL) || ( save_fh == NULL))
   return -1;
 DB_SETKEY( key, save_fh);
 if( fh_db->get( fh_db, &key, &data, 0) != 0){
   return -1;
 }
 if(( data.size - DB_HEADSIZE) > 1){
   strcpy( path, DB_GETPATH( data));
   strcat( path, "/");
   strcat( path, name);
 }
 else
   strcpy( path, name);
 nfs_path2fh( path, &virtual_fh);
 DB_SETKEY( key, &virtual_fh);
 if( fh_db->del( fh_db, &key, 0) == -1){
   return -1;
 }
 return 0;
}

nfspath nfs_fh2path( nfs_fh *fh)
{
 DBT key, data;
 
 if( fh_db == NULL)
   return NULL;
 DB_SETKEY( key, fh);
 if( fh_db->get( fh_db, &key, &data, 0) != 0)
   return NULL;
 return DB_GETPATH( data);
}

int nfs_path2fh( nfspath path, nfs_fh *fh)
{
 static u_int32_t hash4( const void *, size_t);
 nfs_fhhash_t hash;
 
 if( path == NULL)
   return -1;
 hash = htonl( hash4( path, strlen( path) + 1));
 memset( fh, 0, NFS_FHSIZE);
 bcopy( &hash, fh, sizeof( hash));
 return 0;
}

nfs_fh *nfs_fhseq( bool_t start)
{
#ifdef DEBUG
 static int i = 0;
#endif
 DBT key, data;
 
 if( fh_db == NULL)
   return NULL; 
 if( start){
   nfs_fhrefresh();
   if( fh_db->seq( fh_db, &key, &data, R_FIRST) != 0){
#ifdef DEBUG
     fprintf( stderr, ":     \n");
#endif
     return NULL;
   }    
#ifdef DEBUG
   i = 0;
#endif
 }
 else
   if( fh_db->seq( fh_db, &key, &data, R_NEXT) != 0)
     return NULL;
#ifdef DEBUG
 fprintf( stderr, " %6d: %s\n", ++i, DB_GETPATH( data));
#endif
 return (nfs_fh *) key.data;
}

void nfs_fhupdate( nfs_fh *fh)
{
 extern CLIENT *clnt;
 readdirargs argument;
 readdirres clnt_res, *result;
 nfscookie cookie;
 register bool_t retry;
 bool_t fhflag = nfs_fhflag;
 
 nfs_fhflag = FALSE;
#ifdef DEBUG
 nfs_printfh( "", fh);
#endif
 memset( &cookie, 0, sizeof( nfscookie));
 do {
   bcopy( fh, &argument.dir, NFS_FHSIZE);
   bcopy( &cookie, &argument.cookie, sizeof( nfscookie));
   argument.count = NFS_MAXDATA;
   if(( result = nfsproc_readdir_2( &argument, &clnt_res, clnt)) == NULL)
     break;
   if( result->status == NFS_OK){
     entry *entryp = result->readdirres_u.reply.entries;
     readdirres dirres;
     diropargs argument;
      
     retry = !result->readdirres_u.reply.eof;
     bcopy( result, &dirres, sizeof( dirres)); 
     for( ; entryp != NULL; entryp = entryp->nextentry){
       diropres clnt_res, *result;
       
       if( entryp->nextentry == NULL)
         bcopy( &entryp->cookie, &cookie, sizeof( nfscookie));
       if( !strcmp( entryp->name, ".")  || !strcmp( entryp->name, ".."))
         continue;
       bcopy( fh, &argument.dir, NFS_FHSIZE);
       argument.name = entryp->name;
       if(( result = nfsproc_lookup_2( &argument, &clnt_res, clnt)) == NULL)
         continue;
#ifdef DEBUG
/*       fprintf( stderr, ": %s\n", argument.name); clearerr( stdin); getchar();*/
       fprintf( stderr, ": %s\n", argument.name); clearerr( stdin);
#endif
       if(( result->status == NFS_OK) &&
        	( result->diropres_u.diropres.attributes.type == NFDIR)){
         nfs_fh fh;
         
         bcopy( &result->diropres_u.diropres.file, &fh, NFS_FHSIZE); 
#ifdef DEBUG
	 fprintf( stderr, " : %s\n", argument.name);
#endif
         nfs_fhupdate( &fh);
       }
     }
     bcopy( &dirres, result, sizeof( dirres));
     clnt_freeres( clnt, (xdrproc_t) xdr_readdirres, (char *) result);
   }
   else
     retry = FALSE;
 } while( retry);
 nfs_fhflag = fhflag;
}

void nfs_fhrefresh( void)
{
 extern CLIENT *clnt;
 
#ifdef DEBUG
 fprintf( stderr, ":\t\n");
#endif
 if( fh_db != NULL){
   DBT key, data;

   nfs_fhupdate( &root_fh);
   if( fh_db->seq( fh_db, &key, &data, R_FIRST) == 0){
     bool_t fhflag = nfs_fhflag;
     nfs_fh argument;
     attrstat result;

     do {
       bcopy( key.data, &argument, NFS_FHSIZE);
       memset( &result, 0, sizeof( result));
       nfs_fhflag = FALSE;
       if( nfsproc_getattr_2( &argument, &result, clnt) != NULL){
         clnt_freeres( clnt, (xdrproc_t) xdr_attrstat, (char *) &result);
         if( result.status == NFS_OK){
#ifdef DEBUG
           fprintf( stderr, ":\t%s\n", DB_GETPATH( data));
#endif
           continue;
         }
       }
#ifdef DEBUG
       fprintf( stderr, ":\t\t%s\n", DB_GETPATH( data));
#endif
       if( fh_db->del( fh_db, &key, 0) != 0){
#ifdef DEBUG
         fprintf( stderr, ":\t\t%s\t()\n", DB_GETPATH( data));
#endif
       }
     } while( fh_db->seq( fh_db, &key, &data, R_NEXT) == 0);
     nfs_fhflag = fhflag;
   }
 }
#ifdef DEBUG
 fprintf( stderr, ":\t\n");
#endif
}

void nfs_printfh( char *msg, nfs_fh *fh)
{
 unsigned char *s = (unsigned char *) fh;
 register i = 0;

 fprintf( stderr, "%s\t", msg);
 while( i < NFS_FHSIZE)
   fprintf( stderr, "%02x", s[i++]);
 fprintf( stderr, "\n");
}

void nfs_fhsync( void)
{
 if( fh_db != NULL)
   fh_db->sync( fh_db, 0);
}

void nfs_fhclose( void)
{
 if( fh_db != NULL)
   fh_db->close( fh_db);
}

/* Hash function from Chris Torek. */
static u_int32_t
hash4(keyarg, len)
	const void *keyarg;
	register size_t len;
{
	register const u_char *key;
	register size_t loop;
	register u_int32_t h;

#define HASH4a   h = (h << 5) - h + *key++;
#define HASH4b   h = (h << 5) + h + *key++;
#define HASH4 HASH4b

	h = 0;
	key = keyarg;
	if (len > 0) {
		loop = (len + 8 - 1) >> 3;

		switch (len & (8 - 1)) {
		case 0:
			do {
				HASH4;
				/* FALLTHROUGH */
		case 7:
				HASH4;
				/* FALLTHROUGH */
		case 6:
				HASH4;
				/* FALLTHROUGH */
		case 5:
				HASH4;
				/* FALLTHROUGH */
		case 4:
				HASH4;
				/* FALLTHROUGH */
		case 3:
				HASH4;
				/* FALLTHROUGH */
		case 2:
				HASH4;
				/* FALLTHROUGH */
		case 1:
				HASH4;
			} while (--loop);
		}
	}
	return (h);
}
