#include "resource.h"

namespace ClusterManagement {

void Resource::activate() {
  if (_state == PASSIVE) {
    pid_t pid;

    if (!(pid = ::fork())) {
      ::execl (_scriptName.c_str(), _scriptName.c_str(), "start", NULL);
      std::cerr << "Error during " << _scriptName << " activation\n";
      exit( 0);
    }

#ifdef DEBUG
    std::cout << _scriptName << " activated\n";
#endif

    _state = ACTIVE;
  }
}

void Resource::deactivate() {
  if (_state == ACTIVE) {
    pid_t pid;

    if (!(pid = ::fork())) {
      ::execl (_scriptName.c_str(), _scriptName.c_str(), "stop", NULL);
      std::cerr << "Error during " << _scriptName << " deactivation\n";
      exit( 0);
    }

#ifdef DEBUG
    std::cout << _scriptName << " deactivated\n";
#endif

    _state = PASSIVE;
  }
}

std::ostream& operator<< (std::ostream& s, const Resource& r) {
  return s << "Node: " << r.getNode() << " Name: " << r.getName() << " Priority: " << r.getPriority();
}

} // end of namespace
