#ifndef _CLMANAGEMENT_RESOURCETABLE_H
#define _CLMANAGEMENT_RESOURCETABLE_H

#include <string>
#include <list>
#include <iostream>

#include <sys/types.h>

#include "resource.h"

namespace ClusterManagement {

typedef std::list<Resource>::const_iterator Rcit;
typedef std::list<Resource>::iterator Rit;
typedef std::list<Resource> ResTable;

class ResourceTable {
public:
  ResourceTable() : _isSorted(false) {}
  u_int16_t getPriority (const std::string& node, const std::string& name) const;
  std::string getBestNode (const std::string& name);

  const ResTable& getResTable() const {
    return _rTable;
  }

  bool addResource (const Resource& info);
  bool addResource (const std::string& node, const std::string& name, u_int16_t priority);
  bool changeResource (const std::string& node, const std::string& name, u_int16_t priority);
  bool delResource (const std::string& node, const std::string& name);
  void delResource (const std::string& name);
  void delNode (const std::string& node);
  void activate(const std::string& name, const std::string& node);
  void deactivate(const std::string& name, const std::string& node);
  void sort();
#ifdef DEBUG

  u_int size() const {
    return _rTable.size();
  }
#endif
private:

struct ResourceNameCompare : public std::unary_function<Resource, bool> {
    ResourceNameCompare(std::string name) : _name(name) {}
    bool operator()(const Resource& r) const {
      return (r.getName() == _name);
    }
private:
    const std::string _name;
};

struct ResourceCompare : public std::unary_function<Resource, bool> {
    ResourceCompare(std::string name, std::string node) : _name(name), _node(node) {}
    bool operator()(const Resource& r) const {
      return ((r.getName() == _name) && (r.getNode() == _node));
    }
private:
    const std::string _name;
    const std::string _node;
};
  
struct NodeNameCompare : public std::unary_function<Resource, bool> {
    NodeNameCompare(std::string name) : _name(name) {}
    bool operator()(const Resource& r) const {
      return (r.getNode() == _name);
    }
private:
    const std::string _name;
};

  std::list<Resource> _rTable;
  bool _isSorted;
};

std::ostream& operator<< (std::ostream& s, const ResourceTable& rt);

}

#endif /* _CLMANAGEMENT_RESOURCETABLE_H */
