/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void MainWindow::init() {
  QTimer *internalTimer = new QTimer( this ); // create internal timer
  connect( internalTimer, SIGNAL(timeout()), this, SLOT(timeout()) );
  internalTimer->start(5000 );  // emit signal every 5 seconds

  addForm = 0;
  changeForm = 0;
  resourceListView->setColumnAlignment (1, Qt::AlignHCenter);
  proc = new QProcess(this);
  proc->addArgument( "cl_list" );
  connect( proc, SIGNAL(processExited()), this, SLOT(readResourcesList()) );

  timeout();
}

void MainWindow::readResourcesList() {
  if (!proc->normalExit() || proc->exitStatus()) {
    resourceListView->clear();
    return ;
  }

  QString new_data = QDeepCopy<QString>(proc->readStdout());
  if (new_data.isEmpty()) {
    resourceListView->clear();
    data.truncate(0);
    return ;
  }
  if (new_data == data)
    return ;

  data = QDeepCopy<QString>(new_data);
  resourceListView->clear();
  QTextStream ts( &data, IO_ReadOnly );
  QString node, name, priority, image;
  QListViewItem* vi = 0, *vi1;

  while (!ts.atEnd()) {
    ts >> node >> name >> priority;
    node.replace("#Manager#", "");
    image = "d_home.png";

    QListViewItemIterator it( resourceListView );
    while ( it.current() ) {
      vi = it.current();
      if ((vi->text(0) == name) && vi->childCount())
        break;
      ++it;
    }

    if (!it.current()) {
      vi = new QListViewItem (resourceListView, name);
      vi->setPixmap(0, QPixmap::fromMimeSource("project.png"));
      vi->setOpen(true);
      image = "home.png";
    }
    vi1 = new QListViewItem (vi, node, priority);
    vi1->setPixmap(0, QPixmap::fromMimeSource(image));
  }
}

void MainWindow::timeout() {
  if (!proc->isRunning() && !proc->start())
    QMessageBox::critical( 0,
      trUtf8("Ошибка!"),
      trUtf8("Не могу запустить команду cl_list!"),
      tr("Ok") );
}

void MainWindow::addResource() {
  if (!addForm) {
    addForm = new AddForm();
    connect( addForm,
             SIGNAL( newResource (const QString &, const QString &, const QString &)),
             this,
             SLOT( newResource (const QString &, const QString &, const QString &)));
  }

  QListViewItem* item = resourceListView->selectedItem();
  QString name, priority;

  if (item) {
    name = item->text(0);
    priority = item->text(1);
    if (priority.isEmpty())
      addForm->resourceLineEdit->setText(name);
    else {
      item = item->parent();
      addForm->resourceLineEdit->setText(item->text(0));
      addForm->nodeLineEdit->setText(name);
      addForm->prioritySpinBox->setValue(priority.toInt());
    }
  }

  addForm->show();
}

void MainWindow::newResource( const QString & name, const QString & node, const QString & priority ) {
  if (name.isEmpty() || node.isEmpty() || priority.isEmpty()) {
    statusBar()->message(
      trUtf8("Не указаны все необходимые параметры!"), 2000);
    return ;
  }

  QProcess add(this);
  add.addArgument( "cl_add" );
  add.addArgument("-n");
  add.addArgument(node);
  add.addArgument("-r");
  add.addArgument(name);
  add.addArgument("-p");
  add.addArgument(priority);
  if (!add.start()) {
    QMessageBox::critical( 0,
      trUtf8("Ошибка!"),
      trUtf8("Не могу запустить команду cl_add!"),
      tr("Ok") );
  }
  timeout ();
}

void MainWindow::fileOpen() {
  QString name = QFileDialog::getOpenFileName(
                   QString::null, trUtf8("XML файлы (*.xml)"), this,
                   "file open",
		   trUtf8("Загрузить таблицу ресурсов"));
  if (!name.isEmpty())
    load(name);
}

void MainWindow::addNodes (QDomNode node) {
  QString name = "";

  while ( !node.isNull() ) {
    if (node.nodeName() == "name")
      if (name.isEmpty())
        name = node.toElement().text();
      else
        return ;
    else if (node.nodeName() == "node") {
      newResource(name, node.toElement().text(), node.toElement().attribute("priority"));
      ::usleep(100000);
    }
    node = node.nextSibling();
  }
}

void MainWindow::load(const QString& file) {
  QFile resFile(file);
  if ( !resFile.open(IO_ReadOnly)) {
    QMessageBox::critical( 0,
      trUtf8("Ошибка!"),
      trUtf8(QString("Не могу открыть файл %1" ).arg(file)),
      tr("Ok") );
    return ;
  }

  QDomDocument domTree;
  if (!domTree.setContent(&resFile)) {
    QMessageBox::critical( 0,
      trUtf8("Ошибка!"),
      trUtf8(QString("Ошибка при разборе файла %1" ).arg(file) ),
      tr("Ok") );
    resFile.close();
    return ;
  }
  resFile.close();

  QDomElement root = domTree.documentElement();
  QDomNode node;
  QString name;
  node = root.firstChild();
  while ( !node.isNull() ) {
    if (node.isElement() && (node.nodeName() == "resource"))
      addNodes (node.firstChild());
    node = node.nextSibling();
  }
}

void MainWindow::fileSave(QString& filename) {
  QFile file (filename);
  resourceListView->setSorting (1, FALSE);
  if (file.open(IO_WriteOnly)) {
    QTextStream stream( &file );
    QListViewItemIterator it( resourceListView );
    QListViewItem* vi;
    stream << "<resourcelist>\n";
    bool resDef = false;
    for ( QListViewItemIterator it( resourceListView ); it.current(); ++it) {
      vi = it.current();
      if (vi->text(1))
        stream << QString("\t\t<node priority=\"%1\">%2</node>\n").arg(vi->text(1)).arg(vi->text(0));
      else {
        if (!resDef)
          resDef = true;
        else
          stream << "\t</resource>\n";
        stream << QString("\t<resource>\n\t\t<name>%1</name>\n").arg(vi->text(0));
      }
    }
    stream << "\t</resource>\n</resourcelist>\n";
    file.close();
    resourceListView->setSorting (0);
  }
  else
    statusBar()->message(trUtf8(QString( "Ошибка при сохранении файла! '%1'" ).arg(filename )), 3000 );
}

void MainWindow::fileSaveAs() {
  QString filename = QFileDialog::getSaveFileName(
                       QString::null, trUtf8("XML файлы (*.xml)"), this,
                       "file save as",
		       trUtf8("Сохранить файл как..."));
  if (!filename.isEmpty()) {
    if (!filename.endsWith(".xml"))
      filename += ".xml";
    if (!QFile::exists( filename )) {
      fileSave(filename);
      return ;
    }
    else if (!QMessageBox::warning(
               this, trUtf8("Перезаписать файл?"),
               trUtf8(QString( "Перезаписать\n'%1'?" ).arg( filename )),
               trUtf8("Да" ), trUtf8( "Нет"), QString::null, 1, 1)) {
      fileSave(filename);
      return ;
    }
  }
  statusBar()->message(trUtf8("Сохранение отменено"), 2000 );
}

void MainWindow::deleteResource() {
  QListViewItem* item = resourceListView->selectedItem();
  QString name, node, priority;

  if (!item)
    return ;

  node = item->text(0);
  priority = item->text(1);
  if (priority.isEmpty())
    return ;
  else
    name = item->parent()->text(0);

  if (name.isEmpty() || node.isEmpty())
    return ;

  if (!QMessageBox::critical(this, trUtf8("Удаление ресурса!"),
         trUtf8(QString("Удалить ресурс %1 с узла %2?").arg(name).arg(node)),
	 trUtf8("Да" ), trUtf8( "Нет"), QString::null, 0, 1 )) {
    QProcess del(this);
    del.addArgument("cl_delete");
    del.addArgument("-n");
    del.addArgument(node);
    del.addArgument("-r");
    del.addArgument(name);
    if (!del.start())
      QMessageBox::critical( 0,
        trUtf8("Ошибка!"),
        trUtf8("Не могу запустить команду cl_delete!"),
        tr("Ok") );
  }
  timeout();
}

void MainWindow::configureResource() {
  delete (changeForm);
  changeForm = new ChangeForm();
  connect (changeForm,
           SIGNAL( priorityChanged (const QString &, const QString &, const QString &)),
           this,
           SLOT( priorityChanged (const QString &, const QString &, const QString &)));

  QListViewItem* item = resourceListView->selectedItem();
  QString name, node, priority;

  if (item) {
    node = item->text(0);
    priority = item->text(1);
    if (priority.isEmpty())
      return;
    else
      name = item->parent()->text(0);
  }
  if (name.isEmpty() || node.isEmpty())
    return ;

  changeForm->setName(name);
  changeForm->setNode(node);
  changeForm->setPriority(priority);

  changeForm->label->setText(
    trUtf8(QString("Смена приоритета для ресурса %1 на узле %2:").arg(name).arg(node)));
  changeForm->prioritySpinBox->setValue(priority.toInt());
  changeForm->show();
}

void MainWindow::priorityChanged(const QString & name, const QString & node, const QString & priority) {
  QProcess chg(this);
  chg.addArgument( "cl_change" );
  chg.addArgument("-n");
  chg.addArgument(node);
  chg.addArgument("-r");
  chg.addArgument(name);
  chg.addArgument("-p");
  chg.addArgument(priority);
  if (!chg.start()) {
    QMessageBox::critical( 0,
      trUtf8("Ошибка!"),
      trUtf8("Не могу запустить команду cl_change!"),
      tr("Ok") );
  }
  timeout();
}

// XXX: .   event->accept()    :(
void MainWindow::closeEvent(QCloseEvent*) {
  ::exit ( 0);
}
