#ifdef DEBUG
#include <iostream>
#endif

#include <cstdlib>

#include "spreaduser.h"

using std::string;

namespace Spread {

void SpreadUser::connect() {
  int ret = ::SP_connect(_spreadName.c_str(), _userName.c_str(), 0, 1, &_mbox, \
                         _privateGroup);
  if (ret != ACCEPT_SESSION) {
    ::SP_error(ret);
    ::exit ( 1);
  }
#ifdef DEBUG
  else
    std::cout << "User: connected to " << _spreadName << \
    " with private group " << _userName << " mbox: " << _mbox << std::endl;
#endif
}

void SpreadUser::join(const string& group) {
  string groupName = group.size() ? group : _group;
  if (groupName.size())
    if (!::SP_join(_mbox, groupName.c_str())) {
#ifdef DEBUG
      std::cout << "User: " << _userName << " added to group "\
      << groupName << std::endl;
#endif

      return ;
    }
#ifdef DEBUG
  std::cout << "error during adding to group" << std::endl;
#endif

  ::exit ( 1);
}

void SpreadUser::getMessage() {
  service s;
  char sender[MAX_GROUP_NAME];
  const int maxGr = 30;
  int numGr;
  char groups[maxGr][MAX_GROUP_NAME];
  int16_t mType;
  int endian;
  const int maxMessLen = 1000;
  char mess[maxMessLen];

  int ret = ::SP_receive (_mbox, &s, sender, maxGr, &numGr, groups, &mType,
                          &endian, maxMessLen, mess);

  if (ret < 0) {
    ::SP_error(ret);
    exit ( 1);
  }
  if (Is_membership_mess (s)) {
    if (Is_transition_mess (s)) {
      transitionMess(sender);
#ifdef DEBUG

      std::cout << "Transitional membership message" << std::endl;
#endif

    }
    else if (Is_reg_memb_mess (s)) {
      string name = &mess[::SP_get_vs_set_offset_memb_mess()];
      if (Is_caused_join_mess (s)) {
        joinMess(sender, name, numGr, groups);
#ifdef DEBUG

        std::cout << "New member!" << std::endl;
#endif

      }
      else if (Is_caused_leave_mess (s)) {
        leaveMess(sender, name, numGr, groups);
#ifdef DEBUG

        std::cout << "Member out!" << std::endl;
#endif

      }
      else if (Is_caused_disconnect_mess (s)) {
        disconnectMess(sender, name, numGr, groups);
#ifdef DEBUG

        std::cout << "Member out by disconnect!" << std::endl;
#endif

      }
      else if (Is_caused_network_mess (s)) {
        networkMess(sender, name, numGr, groups);
#ifdef DEBUG

        std::cout << "Network message" << std::endl;
#endif

      }
#ifdef DEBUG
      else
        std::cerr << "Bad type of message!" << std::endl;
#endif

    }
    else {
      selfLeaveMess(sender, maxMessLen, mess);
#ifdef DEBUG

      std::cout << "Self leave message" << std::endl;
#endif

    }
  }
  else if (Is_regular_mess (s)) {
    regularMess(sender, numGr, groups, mType, endian,
                maxMessLen, mess);
#ifdef DEBUG

      std::cout << "Regular message" << std::endl;
#endif
  }
  else {
#ifdef DEBUG
    std::cout << "Error!!!" << std::endl;
#endif

  }
}

void SpreadUser::sendMessage(int16_t mType, const string& message, const string& group, service servType) {
  string groupName = group.size() ? group : _group;
  if (!groupName.size()) {
#ifdef DEBUG
    std::cerr << "Error! Can't define group for receiving!" << std::endl;
#endif

    return ;
  }
  
  int ret = ::SP_multicast(_mbox, servType | SELF_DISCARD, groupName.c_str(),
                 mType, message.size() + 1, message.c_str());
  if (ret < 0) {
    ::SP_error(ret);
    exit ( 1);
  }
}

} // end of namespace
