#ifndef _SPREAD_SPREADUSER_H
#define _SPREAD_SPREADUSER_H

#include <string>

extern "C" {
#include <sp.h>
}

namespace Spread {

class SpreadUser {
public:
  SpreadUser(const std::string& spreadName = "4803@localhost", const std::string& group = "", const std::string& userName = "") :
  _spreadName(spreadName), _group(group), _userName(userName) {}

  void connect();
  void join(const std::string& group = "");
  void getMessage();
  void sendMessage(int16_t mType, const std::string& message, const std::string& group = "",
                   service servType = FIFO_MESS);

  mailbox getMailbox() {
    return _mbox;
  }

  virtual ~SpreadUser() {
    SP_disconnect(_mbox);
  }
protected:
  virtual void transitionMess (const char* sender) {}
  virtual void joinMess (const char* sender, const std::string& name, int numMembers,
                         const char groupMembers[][MAX_GROUP_NAME]) {}
  virtual void leaveMess (const char* sender, const std::string& name, int numMembers,
                          const char groupMembers[][MAX_GROUP_NAME]) {}
  virtual void disconnectMess (const char* sender, const std::string& name,
                               int numMembers, const char groupMembers[][MAX_GROUP_NAME]) {}
  virtual void networkMess (const char* sender, const std::string& name,
                            int numMembers, const char groupMembers[][MAX_GROUP_NAME]) {}
  virtual void selfLeaveMess (const char* sender, int maxMessLen,
                              const char* mess) {}
  virtual void regularMess (const char* sender, int numGroups,
                            const char groupMembers[][MAX_GROUP_NAME], int16_t mType, int endian,
                            int maxMessLen, const char* mess) {}
protected:
  std::string _spreadName;
  std::string _group;
  std::string _userName;
  mailbox _mbox;
  char _privateGroup[MAX_GROUP_NAME];
};

} // end of namespace

#endif
