#ifndef _CLMANAGEMENT_MANAGER_H
#define _CLMANAGEMENT_MANAGER_H

#include <vector>
#include <iostream>

#include <sp.h>

#include "spreaduser.h"
#include "resourcetable.h"

namespace ClusterManagement {

enum MType {
  NULL_MSG,
  NEW_RESOURCE,
  CHANGE_RESOURCE,
  DEL_RESOURCE,
  CLUSTER_RESOURCES_LIST,
  GET_RESOURCES_LIST
};

const std::string MANAGER_GROUP = "ClusterManagement";

typedef std::vector<std::string>::const_iterator Scit;

class Manager : public Spread::SpreadUser {
  friend std::ostream& operator<< (std::ostream& s, const Manager& m);
public:
  Manager(std::string spreadName = "4803@localhost", std::string group = MANAGER_GROUP,
          std::string userName = "Manager") : Spread::SpreadUser(spreadName, group,
              userName), _groupMembers(0) {}

  u_int16_t getPriority(const std::string& node, const std::string& name) const {
    return _rt.getPriority(node, name);
  }

  u_int16_t getPriority(const std::string& name) const {
    return _rt.getPriority(_userName, name);
  }

  void addResource(const std::string& resourceName, int priority);

  ~Manager() { /*   */
  }
private:
  ResourceTable _rt;
  std::vector<std::string> _groupMembers;

  void joinMess (const char* sender, const std::string& name, int numMembers,
                 const char groupMembers[][MAX_GROUP_NAME]);
  void leaveMess (const char* sender, const std::string& name, int numMembers,
                  const char groupMembers[][MAX_GROUP_NAME]);
  void disconnectMess (const char* sender, const std::string& name, int numMembers,
                       const char groupMembers[][MAX_GROUP_NAME]);
  void networkMess (const char* sender, const std::string& name, int numMembers,
                    const char groupMembers[][MAX_GROUP_NAME]);
  void regularMess (const char* sender, int numGroups,
                    const char groupMembers[][MAX_GROUP_NAME], int16_t mType, int endian,
                    int maxMessLen, const char* message);
  void receiveNodeInit (const std::string& node);
  void receiveNodeLeave (const std::string& node);
  void receiveResourceTable (const std::string& message);
  void receiveNewResource (const std::string& message);
  void receiveChangeResource (const std::string& message);
  void receiveDelResource (const std::string& message);
  void recalculateState (const std::string& name = "");

  struct RecalculateState {
    explicit RecalculateState (Manager* m) : _m(m) {}
    void operator () (const Resource& r) {
      _m->recalculateState(r.getName());
    };
private:
    Manager* _m;
  };

};

std::ostream& operator<< (std::ostream& s, const Manager& m);

}

#endif /* _CLMANAGEMENT_MANAGER_H */
