#ifndef _CLMANAGEMENT_RESOURCE_H
#define _CLMANAGEMENT_RESOURCE_H

#include <string>
#include <iostream>

#include <sys/types.h>
#include <sys/param.h>
#include <unistd.h>

#define SCRIPTPATH "/var/cluster/scripts/"

namespace ClusterManagement {

enum State {
  PASSIVE,
  ACTIVE
};

class Resource {
public:
  Resource(std::string node, std::string name, u_int16_t priority) : _node(node),
  _name(name), _priority(priority), _state(PASSIVE) {
    _scriptName = SCRIPTPATH + _name + ".sh";
  }

  void activate();
  void deactivate();

  std::string getNode() const {
    return _node;
  }
  std::string getName() const {
    return _name;
  }
  u_int16_t getPriority() const {
    return _priority;
  }
  void setPriority(u_int16_t priority) {
    _priority = priority;
  }
  State getState() const {
    return _state;
  }

  bool Resource::operator== (const Resource& r) const {
    return ((_name == r.getName()) && (_node == r.getNode()));
  }

private:
  std::string _node;
  std::string _name;
  u_int16_t _priority;
  State _state;

  std::string _scriptName;
};

std::ostream& operator<< (std::ostream& s, const Resource& r);

} // end of namespace

#endif /* _CLMANAGEMENT_RESOURCE_H */
