#include <iostream>
#include <string>
#include <stdlib.h>
#include <unistd.h>

#include <sp.h>
#include "manager.h"

using std::string;

int main (int argc, char* argv[]) {
  int ch;
  string node, resource, priority;

  while ((ch = getopt(argc, argv, "n:r:")) != -1)
    switch (ch) {
      case 'n':
        node = optarg;
        break;
      case 'r':
        resource = optarg;
        break;
      default:
        std::cerr << ": " << *argv <<
          " -n _ -r _" << std::endl;
	return 1;
    }

  if (node.size() && resource.size()) {
    char name[80];
    char user[8];
    mailbox mBox;

    name[0] = '\0';
    bzero(user, sizeof(user));
    sprintf (user, "%d", getpid());
    int ret = SP_connect("4803@localhost", user, 0, 1, &mBox, name);
    if(ret != ACCEPT_SESSION) {
      std::cout << "\nSP_connect: ";
      SP_error(ret);
      exit ( 1);
    }
#ifdef DEBUG
    else
      std::cout << "User connected with private group " << name << std::endl;
#endif

    node = "#Manager#" + node + "\n" + resource + "\n";
#ifdef DEBUG
    std::cout << node << std::endl;
#endif 
    SP_multicast(mBox, RELIABLE_MESS, ClusterManagement::MANAGER_GROUP.c_str(),
                 ClusterManagement::DEL_RESOURCE, node.size(), node.c_str());
  }
  else
    std::cerr << ": " << *argv <<
      " -n _ -r _" << std::endl;

  return 0;
}
