#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

#include "manager.h"

static void alarm_exit(int) {
  std::cerr << "No nodes available\n";
  exit ( 1);
} 

int main (int argc, char* argv[]) {
  char user[8];
  char name[MAX_GROUP_NAME];
  mailbox mBox;
  
  bzero(user, sizeof(user));
  name[0] = '\0';
  sprintf (user, "%d", getpid());

  int ret = SP_connect("4803@localhost", user, 0, 1, &mBox, name);
  
  if(ret != ACCEPT_SESSION) {
    ::SP_error(ret);
    exit ( 1);
  }
  
  ::alarm(1);
  signal(SIGALRM, alarm_exit);
  
  ret = ::SP_multicast(mBox, RELIABLE_MESS, ClusterManagement::MANAGER_GROUP.c_str(), 
                     ClusterManagement::GET_RESOURCES_LIST, 0, "");
  if(ret < 0) {
    ::SP_error(ret);
    exit ( 1);
  }
  
  service s;
  const int maxGr = 30;
  int numGr;
  char groups[maxGr][MAX_GROUP_NAME];
  int16_t mType;
  int endian;
  const int maxMessLen = 1000;
  char message[maxMessLen];
  
  while ( 1) {
    int ret = ::SP_receive (mBox, &s, name, maxGr, &numGr, groups, &mType,
                            &endian, maxMessLen, message);

    if (ret < 0) {
      ::SP_error(ret);
      exit ( 1);
    }
    if (Is_regular_mess(s) && (mType == ClusterManagement::CLUSTER_RESOURCES_LIST)) {
      std::cout << message;
      exit ( 0);
    }
  }
}
