#!/usr/bin/perl

# written by Jason Rennie <jr6b+@andrew.cmu.edu> for ifile

# knowledge_base.mh is a wrapper for ifile which is specific to the MH
# environment.  It uses ifile to collect word statistics on all mail files
# which are stored in the user's MH mail directories.  

# Full path of ifile binary (if not in $PATH)
$ifile_binary = "ifile";
$ifile_args = "-h -v 2";
$folders_file = ".folders";

################################
# gets environment information #
################################

$home_dir = $ENV{"HOME"}."/";

open(MH, "< $home_dir.mh_profile");

while (<MH>) {
    if (m/^path:\s*(\S+)/i) {
	$mail_path = $1;
	$mail_path .= "/";
	# if mail path is not absolute, make it so
	if ($mail_path =~ m/^[^\/]/) {
	    $mail_path = $home_dir.$mail_path;
	}
    }
}
close(MH);

if (! $mail_path) {
    $mail_path = $home_dir."Mail/";
}

$folders_file = $mail_path.$folders_file;

# reset old word statistics
print "$ifile_binary -r\n";
system "$ifile_binary -r";

open(FOLDER, $folders_file)
    || die "Could not open $folders_file: $!\n";
foreach $folder (<FOLDER>)
{
    chop $folder;
    local(@files);
    
    $dir = $mail_path.$folder;
    $tmp_file = ".ifile".(time() % 100000);

    # Only accumulate data for folders which we have write permissions
    # to and which don't have .skip_me files
    if (! -f "$dir/.skip_me"
	&& open(FOO, "> ".$dir."/".$tmp_file))
    {
	close(FOO);
	unlink($dir."/".$tmp_file);
	
	$num_files = 0;
	opendir(FILES, $dir);
	while ($_ = readdir(FILES))
	{
	    if (m/^\d+$/)
	    {
		$files[$#files+1] = $_;
	    }
	}
	closedir(FILES);
	
	if (@files > 0)
	{
	    chdir $mail_path.$folder;
	    $files_arr_size = @files;
	    print STDERR "$ifile_binary $ifile_args -i $folder $mail_path$folder/* [$files_arr_size]\n";
	    system "$ifile_binary $ifile_args -i $folder ".join(' ', @files);
	}
    }
    else
    {
	print STDERR "Skipping $folder...\n";
    }
}
close(FOLDER);
    
